/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.elasticsearch.ml.get_memory_stats.Memory;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class GetMemoryStatsResponse
implements JsonpSerializable {
    private final NodeStatistics nodeStats;
    private final String clusterName;
    private final Map<String, Memory> nodes;
    public static final JsonpDeserializer<GetMemoryStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetMemoryStatsResponse::setupGetMemoryStatsResponseDeserializer);

    private GetMemoryStatsResponse(Builder builder) {
        this.nodeStats = ApiTypeHelper.requireNonNull(builder.nodeStats, this, "nodeStats");
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
    }

    public static GetMemoryStatsResponse of(Function<Builder, ObjectBuilder<GetMemoryStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Map<String, Memory> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodeStats.serialize(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, Memory> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetMemoryStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes");
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(Memory._DESERIALIZER), "nodes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetMemoryStatsResponse> {
        private NodeStatistics nodeStats;
        private String clusterName;
        private Map<String, Memory> nodes;

        public final Builder nodeStats(NodeStatistics value) {
            this.nodeStats = value;
            return this;
        }

        public final Builder nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder nodes(Map<String, Memory> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        public final Builder nodes(String key, Memory value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        public final Builder nodes(String key, Function<Memory.Builder, ObjectBuilder<Memory>> fn) {
            return this.nodes(key, fn.apply(new Memory.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetMemoryStatsResponse build() {
            this._checkSingleUse();
            return new GetMemoryStatsResponse(this);
        }
    }
}

