// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

/**
 * <p>This package contains annotations for client-side methods that map to REST APIs in the Azure SDK.</p>
 *
 * <p>These annotations are used to define the HTTP method (GET, POST, PUT, DELETE, etc.) and the relative path for the
 * REST endpoint. They also provide a way to specify path parameters, query parameters, and the request body.</p>
 *
 * <p>Here are some of the key annotations included in this package:</p>
 *
 * <ul>
 *     <li>{@link com.azure.core.annotation.Get}: Annotation for HTTP GET method.</li>
 *     <li>{@link com.azure.core.annotation.Put}: Annotation for HTTP PUT method.</li>
 *     <li>{@link com.azure.core.annotation.QueryParam}: Annotation for query parameters to be appended to a REST API
 *     Request URI.</li>
 * </ul>
 */
package com.azure.core.annotation;
