// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Blob info from a Filter Blobs API call.
 */
@Fluent
public final class FilterBlobItem implements XmlSerializable<FilterBlobItem> {
    /*
     * The Name property.
     */
    @Generated
    private String name;

    /*
     * The ContainerName property.
     */
    @Generated
    private String containerName;

    /*
     * Blob tags
     */
    @Generated
    private BlobTags tags;

    /*
     * The VersionId property.
     */
    @Generated
    private String versionId;

    /*
     * The IsCurrentVersion property.
     */
    @Generated
    private Boolean isCurrentVersion;

    /**
     * Creates an instance of FilterBlobItem class.
     */
    @Generated
    public FilterBlobItem() {
    }

    /**
     * Get the name property: The Name property.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The Name property.
     * 
     * @param name the name value to set.
     * @return the FilterBlobItem object itself.
     */
    @Generated
    public FilterBlobItem setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the containerName property: The ContainerName property.
     * 
     * @return the containerName value.
     */
    @Generated
    public String getContainerName() {
        return this.containerName;
    }

    /**
     * Set the containerName property: The ContainerName property.
     * 
     * @param containerName the containerName value to set.
     * @return the FilterBlobItem object itself.
     */
    @Generated
    public FilterBlobItem setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    /**
     * Get the tags property: Blob tags.
     * 
     * @return the tags value.
     */
    @Generated
    public BlobTags getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Blob tags.
     * 
     * @param tags the tags value to set.
     * @return the FilterBlobItem object itself.
     */
    @Generated
    public FilterBlobItem setTags(BlobTags tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the versionId property: The VersionId property.
     * 
     * @return the versionId value.
     */
    @Generated
    public String getVersionId() {
        return this.versionId;
    }

    /**
     * Set the versionId property: The VersionId property.
     * 
     * @param versionId the versionId value to set.
     * @return the FilterBlobItem object itself.
     */
    @Generated
    public FilterBlobItem setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    /**
     * Get the isCurrentVersion property: The IsCurrentVersion property.
     * 
     * @return the isCurrentVersion value.
     */
    @Generated
    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    /**
     * Set the isCurrentVersion property: The IsCurrentVersion property.
     * 
     * @param isCurrentVersion the isCurrentVersion value to set.
     * @return the FilterBlobItem object itself.
     */
    @Generated
    public FilterBlobItem setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Blob" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeStringElement("ContainerName", this.containerName);
        xmlWriter.writeXml(this.tags, "Tags");
        xmlWriter.writeStringElement("VersionId", this.versionId);
        xmlWriter.writeBooleanElement("IsCurrentVersion", this.isCurrentVersion);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of FilterBlobItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of FilterBlobItem if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the FilterBlobItem.
     */
    @Generated
    public static FilterBlobItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of FilterBlobItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of FilterBlobItem if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the FilterBlobItem.
     */
    @Generated
    public static FilterBlobItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Blob" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            FilterBlobItem deserializedFilterBlobItem = new FilterBlobItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.name = reader.getStringElement();
                } else if ("ContainerName".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.containerName = reader.getStringElement();
                } else if ("Tags".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.tags = BlobTags.fromXml(reader, "Tags");
                } else if ("VersionId".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.versionId = reader.getStringElement();
                } else if ("IsCurrentVersion".equals(elementName.getLocalPart())) {
                    deserializedFilterBlobItem.isCurrentVersion = reader.getNullableElement(Boolean::parseBoolean);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedFilterBlobItem;
        });
    }
}
