// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The QuerySerialization model.
 */
@Fluent
public final class QuerySerialization implements XmlSerializable<QuerySerialization> {
    /*
     * The Format property.
     */
    @Generated
    private QueryFormat format;

    /**
     * Creates an instance of QuerySerialization class.
     */
    @Generated
    public QuerySerialization() {
    }

    /**
     * Get the format property: The Format property.
     * 
     * @return the format value.
     */
    @Generated
    public QueryFormat getFormat() {
        return this.format;
    }

    /**
     * Set the format property: The Format property.
     * 
     * @param format the format value to set.
     * @return the QuerySerialization object itself.
     */
    @Generated
    public QuerySerialization setFormat(QueryFormat format) {
        this.format = format;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "QuerySerialization" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.format, "Format");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QuerySerialization from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QuerySerialization if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QuerySerialization.
     */
    @Generated
    public static QuerySerialization fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QuerySerialization from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QuerySerialization if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QuerySerialization.
     */
    @Generated
    public static QuerySerialization fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "QuerySerialization" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QuerySerialization deserializedQuerySerialization = new QuerySerialization();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Format".equals(elementName.getLocalPart())) {
                    deserializedQuerySerialization.format = QueryFormat.fromXml(reader, "Format");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQuerySerialization;
        });
    }
}
