// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Properties of a container.
 */
@Fluent
public final class BlobContainerItemProperties implements XmlSerializable<BlobContainerItemProperties> {

    /*
     * The Last-Modified property.
     */
    @Generated
    private DateTimeRfc1123 lastModified;

    /*
     * The Etag property.
     */
    @Generated
    private String eTag;

    /*
     * The LeaseStatus property.
     */
    @Generated
    private LeaseStatusType leaseStatus;

    /*
     * The LeaseState property.
     */
    @Generated
    private LeaseStateType leaseState;

    /*
     * The LeaseDuration property.
     */
    @Generated
    private LeaseDurationType leaseDuration;

    /*
     * The PublicAccess property.
     */
    @Generated
    private PublicAccessType publicAccess;

    /*
     * The HasImmutabilityPolicy property.
     */
    @Generated
    private Boolean hasImmutabilityPolicy;

    /*
     * The HasLegalHold property.
     */
    @Generated
    private Boolean hasLegalHold;

    /*
     * The DefaultEncryptionScope property.
     */
    @Generated
    private String defaultEncryptionScope;

    /*
     * The DenyEncryptionScopeOverride property.
     */
    @Generated
    private Boolean encryptionScopeOverridePrevented;

    /*
     * The DeletedTime property.
     */
    @Generated
    private DateTimeRfc1123 deletedTime;

    /*
     * The RemainingRetentionDays property.
     */
    @Generated
    private Integer remainingRetentionDays;

    /*
     * Indicates if version level worm is enabled on this container.
     */
    @Generated
    private Boolean isImmutableStorageWithVersioningEnabled;

    /**
     * Creates an instance of BlobContainerItemProperties class.
     */
    @Generated
    public BlobContainerItemProperties() {
    }

    /**
     * Get the lastModified property: The Last-Modified property.
     *
     * @return the lastModified value.
     */
    @Generated
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The Last-Modified property.
     *
     * @param lastModified the lastModified value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the eTag property: The Etag property.
     *
     * @return the eTag value.
     */
    @Generated
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The Etag property.
     *
     * @param eTag the eTag value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the leaseStatus property: The LeaseStatus property.
     *
     * @return the leaseStatus value.
     */
    @Generated
    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    /**
     * Set the leaseStatus property: The LeaseStatus property.
     *
     * @param leaseStatus the leaseStatus value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    /**
     * Get the leaseState property: The LeaseState property.
     *
     * @return the leaseState value.
     */
    @Generated
    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    /**
     * Set the leaseState property: The LeaseState property.
     *
     * @param leaseState the leaseState value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    /**
     * Get the leaseDuration property: The LeaseDuration property.
     *
     * @return the leaseDuration value.
     */
    @Generated
    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    /**
     * Set the leaseDuration property: The LeaseDuration property.
     *
     * @param leaseDuration the leaseDuration value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    /**
     * Get the publicAccess property: The PublicAccess property.
     *
     * @return the publicAccess value.
     */
    @Generated
    public PublicAccessType getPublicAccess() {
        return this.publicAccess;
    }

    /**
     * Set the publicAccess property: The PublicAccess property.
     *
     * @param publicAccess the publicAccess value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setPublicAccess(PublicAccessType publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    /**
     * Get the hasImmutabilityPolicy property: The HasImmutabilityPolicy property.
     *
     * @return the hasImmutabilityPolicy value.
     */
    @Generated
    public Boolean isHasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    /**
     * Set the hasImmutabilityPolicy property: The HasImmutabilityPolicy property.
     *
     * @param hasImmutabilityPolicy the hasImmutabilityPolicy value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setHasImmutabilityPolicy(Boolean hasImmutabilityPolicy) {
        this.hasImmutabilityPolicy = hasImmutabilityPolicy;
        return this;
    }

    /**
     * Get the hasLegalHold property: The HasLegalHold property.
     *
     * @return the hasLegalHold value.
     */
    @Generated
    public Boolean isHasLegalHold() {
        return this.hasLegalHold;
    }

    /**
     * Set the hasLegalHold property: The HasLegalHold property.
     *
     * @param hasLegalHold the hasLegalHold value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setHasLegalHold(Boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
        return this;
    }

    /**
     * Get the defaultEncryptionScope property: The DefaultEncryptionScope property.
     *
     * @return the defaultEncryptionScope value.
     */
    @Generated
    public String getDefaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    /**
     * Set the defaultEncryptionScope property: The DefaultEncryptionScope property.
     *
     * @param defaultEncryptionScope the defaultEncryptionScope value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setDefaultEncryptionScope(String defaultEncryptionScope) {
        this.defaultEncryptionScope = defaultEncryptionScope;
        return this;
    }

    /**
     * Get the encryptionScopeOverridePrevented property: The DenyEncryptionScopeOverride property.
     *
     * @return the encryptionScopeOverridePrevented value.
     */
    @Generated
    public boolean isEncryptionScopeOverridePrevented() {
        return Boolean.TRUE.equals(this.encryptionScopeOverridePrevented);
    }

    /**
     * Set the encryptionScopeOverridePrevented property: The DenyEncryptionScopeOverride property.
     *
     * @param encryptionScopeOverridePrevented the encryptionScopeOverridePrevented value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setEncryptionScopeOverridePrevented(boolean encryptionScopeOverridePrevented) {
        this.encryptionScopeOverridePrevented = encryptionScopeOverridePrevented;
        return this;
    }

    /**
     * Get the deletedTime property: The DeletedTime property.
     *
     * @return the deletedTime value.
     */
    @Generated
    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    /**
     * Set the deletedTime property: The DeletedTime property.
     *
     * @param deletedTime the deletedTime value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setDeletedTime(OffsetDateTime deletedTime) {
        if (deletedTime == null) {
            this.deletedTime = null;
        } else {
            this.deletedTime = new DateTimeRfc1123(deletedTime);
        }
        return this;
    }

    /**
     * Get the remainingRetentionDays property: The RemainingRetentionDays property.
     *
     * @return the remainingRetentionDays value.
     */
    @Generated
    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    /**
     * Set the remainingRetentionDays property: The RemainingRetentionDays property.
     *
     * @param remainingRetentionDays the remainingRetentionDays value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    /**
     * Get the isImmutableStorageWithVersioningEnabled property: Indicates if version level worm is enabled on this
     * container.
     *
     * @return the isImmutableStorageWithVersioningEnabled value.
     */
    @Generated
    public Boolean isImmutableStorageWithVersioningEnabled() {
        return this.isImmutableStorageWithVersioningEnabled;
    }

    /**
     * Set the isImmutableStorageWithVersioningEnabled property: Indicates if version level worm is enabled on this
     * container.
     *
     * @param isImmutableStorageWithVersioningEnabled the isImmutableStorageWithVersioningEnabled value to set.
     * @return the BlobContainerItemProperties object itself.
     */
    @Generated
    public BlobContainerItemProperties
        setImmutableStorageWithVersioningEnabled(Boolean isImmutableStorageWithVersioningEnabled) {
        this.isImmutableStorageWithVersioningEnabled = isImmutableStorageWithVersioningEnabled;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "BlobContainerItemProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration",
            this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("PublicAccess", this.publicAccess == null ? null : this.publicAccess.toString());
        xmlWriter.writeBooleanElement("HasImmutabilityPolicy", this.hasImmutabilityPolicy);
        xmlWriter.writeBooleanElement("HasLegalHold", this.hasLegalHold);
        xmlWriter.writeStringElement("DefaultEncryptionScope", this.defaultEncryptionScope);
        xmlWriter.writeBooleanElement("DenyEncryptionScopeOverride", this.encryptionScopeOverridePrevented);
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeBooleanElement("ImmutableStorageWithVersioningEnabled",
            this.isImmutableStorageWithVersioningEnabled);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobContainerItemProperties from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobContainerItemProperties if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobContainerItemProperties.
     */
    @Generated
    public static BlobContainerItemProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobContainerItemProperties from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobContainerItemProperties if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobContainerItemProperties.
     */
    @Generated
    public static BlobContainerItemProperties fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "BlobContainerItemProperties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobContainerItemProperties deserializedBlobContainerItemProperties = new BlobContainerItemProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.lastModified
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.eTag = reader.getStringElement();
                } else if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.leaseStatus
                        = LeaseStatusType.fromString(reader.getStringElement());
                } else if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.leaseState
                        = LeaseStateType.fromString(reader.getStringElement());
                } else if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.leaseDuration
                        = LeaseDurationType.fromString(reader.getStringElement());
                } else if ("PublicAccess".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.publicAccess
                        = PublicAccessType.fromString(reader.getStringElement());
                } else if ("HasImmutabilityPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.hasImmutabilityPolicy
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("HasLegalHold".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.hasLegalHold
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DefaultEncryptionScope".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.defaultEncryptionScope = reader.getStringElement();
                } else if ("DenyEncryptionScopeOverride".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.encryptionScopeOverridePrevented
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.deletedTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.remainingRetentionDays
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("ImmutableStorageWithVersioningEnabled".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItemProperties.isImmutableStorageWithVersioningEnabled
                        = reader.getNullableElement(Boolean::parseBoolean);
                } else {
                    reader.skipElement();
                }
            }
            return deserializedBlobContainerItemProperties;
        });
    }
}
