// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * a summary of request statistics grouped by API in hour or minute aggregates for blobs.
 */
@Fluent
public final class BlobMetrics implements XmlSerializable<BlobMetrics> {
    /*
     * The version of Storage Analytics to configure.
     */
    @Generated
    private String version;

    /*
     * Indicates whether metrics are enabled for the Blob service.
     */
    @Generated
    private boolean enabled;

    /*
     * Indicates whether metrics should generate summary statistics for called API operations.
     */
    @Generated
    private Boolean includeApis;

    /*
     * the retention policy which determines how long the associated data should persist
     */
    @Generated
    private BlobRetentionPolicy retentionPolicy;

    /**
     * Creates an instance of BlobMetrics class.
     */
    @Generated
    public BlobMetrics() {
    }

    /**
     * Get the version property: The version of Storage Analytics to configure.
     * 
     * @return the version value.
     */
    @Generated
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of Storage Analytics to configure.
     * 
     * @param version the version value to set.
     * @return the BlobMetrics object itself.
     */
    @Generated
    public BlobMetrics setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the enabled property: Indicates whether metrics are enabled for the Blob service.
     * 
     * @return the enabled value.
     */
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether metrics are enabled for the Blob service.
     * 
     * @param enabled the enabled value to set.
     * @return the BlobMetrics object itself.
     */
    @Generated
    public BlobMetrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the includeApis property: Indicates whether metrics should generate summary statistics for called API
     * operations.
     * 
     * @return the includeApis value.
     */
    @Generated
    public Boolean isIncludeApis() {
        return this.includeApis;
    }

    /**
     * Set the includeApis property: Indicates whether metrics should generate summary statistics for called API
     * operations.
     * 
     * @param includeApis the includeApis value to set.
     * @return the BlobMetrics object itself.
     */
    @Generated
    public BlobMetrics setIncludeApis(Boolean includeApis) {
        this.includeApis = includeApis;
        return this;
    }

    /**
     * Get the retentionPolicy property: the retention policy which determines how long the associated data should
     * persist.
     * 
     * @return the retentionPolicy value.
     */
    @Generated
    public BlobRetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: the retention policy which determines how long the associated data should
     * persist.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the BlobMetrics object itself.
     */
    @Generated
    public BlobMetrics setRetentionPolicy(BlobRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "BlobMetrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeApis);
        xmlWriter.writeXml(this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobMetrics from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobMetrics if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobMetrics.
     */
    @Generated
    public static BlobMetrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobMetrics from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobMetrics if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobMetrics.
     */
    @Generated
    public static BlobMetrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "BlobMetrics" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobMetrics deserializedBlobMetrics = new BlobMetrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.version = reader.getStringElement();
                } else if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.enabled = reader.getBooleanElement();
                } else if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.includeApis = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedBlobMetrics.retentionPolicy = BlobRetentionPolicy.fromXml(reader, "RetentionPolicy");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobMetrics;
        });
    }
}
