// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

/**
 * Defines values for BlobType.
 */
public enum BlobType {
    /**
     * Enum value BlockBlob.
     */
    BLOCK_BLOB("BlockBlob"),

    /**
     * Enum value PageBlob.
     */
    PAGE_BLOB("PageBlob"),

    /**
     * Enum value AppendBlob.
     */
    APPEND_BLOB("AppendBlob");

    /**
     * The actual serialized value for a BlobType instance.
     */
    private final String value;

    BlobType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a BlobType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed BlobType object, or null if unable to parse.
     */
    public static BlobType fromString(String value) {
        if (value == null) {
            return null;
        }
        BlobType[] items = BlobType.values();
        for (BlobType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
