// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.storage.blob.implementation.models.PageListHelper;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * the list of pages.
 */
@Fluent
public final class PageList implements XmlSerializable<PageList> {

    static {
        PageListHelper.setAccessor(new PageListHelper.PageListAccessor() {

            @Override
            public String getNextMarker(PageList pageList) {
                return pageList.getNextMarker();
            }

            @Override
            public PageList setNextMarker(PageList pageList, String marker) {
                return pageList.setNextMarker(marker);
            }
        });
    }

    /*
     * The PageRange property.
     */
    @Generated
    private List<PageRange> pageRange = new ArrayList<>();

    /*
     * The ClearRange property.
     */
    @Generated
    private List<ClearRange> clearRange = new ArrayList<>();

    /*
     * The NextMarker property.
     */
    @Generated
    private String nextMarker;

    /**
     * Creates an instance of PageList class.
     */
    @Generated
    public PageList() {
    }

    /**
     * Get the pageRange property: The PageRange property.
     *
     * @return the pageRange value.
     */
    @Generated
    public List<PageRange> getPageRange() {
        return this.pageRange;
    }

    /**
     * Set the pageRange property: The PageRange property.
     *
     * @param pageRange the pageRange value to set.
     * @return the PageList object itself.
     */
    @Generated
    public PageList setPageRange(List<PageRange> pageRange) {
        this.pageRange = pageRange;
        return this;
    }

    /**
     * Get the clearRange property: The ClearRange property.
     *
     * @return the clearRange value.
     */
    @Generated
    public List<ClearRange> getClearRange() {
        return this.clearRange;
    }

    /**
     * Set the clearRange property: The ClearRange property.
     *
     * @param clearRange the clearRange value to set.
     * @return the PageList object itself.
     */
    @Generated
    public PageList setClearRange(List<ClearRange> clearRange) {
        this.clearRange = clearRange;
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     *
     * @return the nextMarker value.
     */
    @Generated
    private String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     *
     * @param nextMarker the nextMarker value to set.
     * @return the PageList object itself.
     */
    @Generated
    private PageList setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "PageList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.pageRange != null) {
            for (PageRange element : this.pageRange) {
                xmlWriter.writeXml(element, "PageRange");
            }
        }
        if (this.clearRange != null) {
            for (ClearRange element : this.clearRange) {
                xmlWriter.writeXml(element, "ClearRange");
            }
        }
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of PageList from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of PageList if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the PageList.
     */
    @Generated
    public static PageList fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of PageList from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of PageList if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the PageList.
     */
    @Generated
    public static PageList fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "PageList" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageList deserializedPageList = new PageList();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("PageRange".equals(elementName.getLocalPart())) {
                    deserializedPageList.pageRange.add(PageRange.fromXml(reader, "PageRange"));
                } else if ("ClearRange".equals(elementName.getLocalPart())) {
                    deserializedPageList.clearRange.add(ClearRange.fromXml(reader, "ClearRange"));
                } else if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedPageList.nextMarker = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }
            return deserializedPageList;
        });
    }
}
