// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

/**
 * Defines values for PermissionCopyModeType.
 */
public enum PermissionCopyModeType {
    /**
     * Enum value source.
     */
    SOURCE("source"),

    /**
     * Enum value override.
     */
    OVERRIDE("override");

    /**
     * The actual serialized value for a PermissionCopyModeType instance.
     */
    private final String value;

    PermissionCopyModeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PermissionCopyModeType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed PermissionCopyModeType object, or null if unable to parse.
     */
    public static PermissionCopyModeType fromString(String value) {
        if (value == null) {
            return null;
        }
        PermissionCopyModeType[] items = PermissionCopyModeType.values();
        for (PermissionCopyModeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
