// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

/**
 * Access rights of the access policy.
 */
public enum ShareFileHandleAccessRights {
    /**
     * Enum value Read.
     */
    READ("Read"),

    /**
     * Enum value Write.
     */
    WRITE("Write"),

    /**
     * Enum value Delete.
     */
    DELETE("Delete");

    /**
     * The actual serialized value for a AccessRight instance.
     */
    private final String value;

    ShareFileHandleAccessRights(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AccessRight instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AccessRight object, or null if unable to parse.
     */
    public static ShareFileHandleAccessRights fromString(String value) {
        if (value == null) {
            return null;
        }
        ShareFileHandleAccessRights[] items = ShareFileHandleAccessRights.values();
        for (ShareFileHandleAccessRights item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
