// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * An Azure Storage file range.
 */
@Fluent
public final class FileRange implements XmlSerializable<FileRange> {
    /*
     * Start of the range.
     */
    @Generated
    private long start;

    /*
     * End of the range.
     */
    @Generated
    private long end;

    /**
     * Creates an instance of FileRange class.
     */
    @Generated
    public FileRange() {
    }

    /**
     * Get the start property: Start of the range.
     * 
     * @return the start value.
     */
    @Generated
    public long getStart() {
        return this.start;
    }

    /**
     * Set the start property: Start of the range.
     * 
     * @param start the start value to set.
     * @return the FileRange object itself.
     */
    @Generated
    public FileRange setStart(long start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: End of the range.
     * 
     * @return the end value.
     */
    @Generated
    public long getEnd() {
        return this.end;
    }

    /**
     * Set the end property: End of the range.
     * 
     * @param end the end value to set.
     * @return the FileRange object itself.
     */
    @Generated
    public FileRange setEnd(long end) {
        this.end = end;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Range" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeLongElement("Start", this.start);
        xmlWriter.writeLongElement("End", this.end);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of FileRange from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of FileRange if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws XMLStreamException If an error occurs while reading the FileRange.
     */
    @Generated
    public static FileRange fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of FileRange from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of FileRange if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws XMLStreamException If an error occurs while reading the FileRange.
     */
    @Generated
    public static FileRange fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Range" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            FileRange deserializedFileRange = new FileRange();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedFileRange.start = reader.getLongElement();
                } else if ("End".equals(elementName.getLocalPart())) {
                    deserializedFileRange.end = reader.getLongElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedFileRange;
        });
    }
}
