// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Storage service properties.
 */
@Fluent
public final class ShareServiceProperties implements XmlSerializable<ShareServiceProperties> {
    /*
     * A summary of request statistics grouped by API in hourly aggregates for files.
     */
    @Generated
    private ShareMetrics hourMetrics;

    /*
     * A summary of request statistics grouped by API in minute aggregates for files.
     */
    @Generated
    private ShareMetrics minuteMetrics;

    /*
     * The set of CORS rules.
     */
    @Generated
    private List<ShareCorsRule> cors;

    /*
     * Protocol settings
     */
    @Generated
    private ShareProtocolSettings protocol;

    /**
     * Creates an instance of ShareServiceProperties class.
     */
    @Generated
    public ShareServiceProperties() {
    }

    /**
     * Get the hourMetrics property: A summary of request statistics grouped by API in hourly aggregates for files.
     * 
     * @return the hourMetrics value.
     */
    @Generated
    public ShareMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    /**
     * Set the hourMetrics property: A summary of request statistics grouped by API in hourly aggregates for files.
     * 
     * @param hourMetrics the hourMetrics value to set.
     * @return the ShareServiceProperties object itself.
     */
    @Generated
    public ShareServiceProperties setHourMetrics(ShareMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    /**
     * Get the minuteMetrics property: A summary of request statistics grouped by API in minute aggregates for files.
     * 
     * @return the minuteMetrics value.
     */
    @Generated
    public ShareMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    /**
     * Set the minuteMetrics property: A summary of request statistics grouped by API in minute aggregates for files.
     * 
     * @param minuteMetrics the minuteMetrics value to set.
     * @return the ShareServiceProperties object itself.
     */
    @Generated
    public ShareServiceProperties setMinuteMetrics(ShareMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    /**
     * Get the cors property: The set of CORS rules.
     * 
     * @return the cors value.
     */
    @Generated
    public List<ShareCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new ArrayList<>();
        }
        return this.cors;
    }

    /**
     * Set the cors property: The set of CORS rules.
     * 
     * @param cors the cors value to set.
     * @return the ShareServiceProperties object itself.
     */
    @Generated
    public ShareServiceProperties setCors(List<ShareCorsRule> cors) {
        this.cors = cors;
        return this;
    }

    /**
     * Get the protocol property: Protocol settings.
     * 
     * @return the protocol value.
     */
    @Generated
    public ShareProtocolSettings getProtocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Protocol settings.
     * 
     * @param protocol the protocol value to set.
     * @return the ShareServiceProperties object itself.
     */
    @Generated
    public ShareServiceProperties setProtocol(ShareProtocolSettings protocol) {
        this.protocol = protocol;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "StorageServiceProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.hourMetrics, "HourMetrics");
        xmlWriter.writeXml(this.minuteMetrics, "MinuteMetrics");
        if (this.cors != null) {
            xmlWriter.writeStartElement("Cors");
            for (ShareCorsRule element : this.cors) {
                xmlWriter.writeXml(element, "CorsRule");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeXml(this.protocol, "ProtocolSettings");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ShareServiceProperties from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of ShareServiceProperties if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareServiceProperties.
     */
    @Generated
    public static ShareServiceProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ShareServiceProperties from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ShareServiceProperties if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareServiceProperties.
     */
    @Generated
    public static ShareServiceProperties fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "StorageServiceProperties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareServiceProperties deserializedShareServiceProperties = new ShareServiceProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("HourMetrics".equals(elementName.getLocalPart())) {
                    deserializedShareServiceProperties.hourMetrics = ShareMetrics.fromXml(reader, "HourMetrics");
                } else if ("MinuteMetrics".equals(elementName.getLocalPart())) {
                    deserializedShareServiceProperties.minuteMetrics = ShareMetrics.fromXml(reader, "MinuteMetrics");
                } else if ("Cors".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("CorsRule".equals(elementName.getLocalPart())) {
                            if (deserializedShareServiceProperties.cors == null) {
                                deserializedShareServiceProperties.cors = new ArrayList<>();
                            }
                            deserializedShareServiceProperties.cors.add(ShareCorsRule.fromXml(reader, "CorsRule"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else if ("ProtocolSettings".equals(elementName.getLocalPart())) {
                    deserializedShareServiceProperties.protocol
                        = ShareProtocolSettings.fromXml(reader, "ProtocolSettings");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedShareServiceProperties;
        });
    }
}
