/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class FilesDeleteHeaders {
    private String xMsVersion;
    private Long xMsLinkCount;
    private String xMsRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_LINK_COUNT = HttpHeaderName.fromString((String)"x-ms-link-count");

    public FilesDeleteHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsLinkCount = rawHeaders.getValue(X_MS_LINK_COUNT);
        this.xMsLinkCount = xMsLinkCount != null ? Long.valueOf(Long.parseLong(xMsLinkCount)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public FilesDeleteHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Long getXMsLinkCount() {
        return this.xMsLinkCount;
    }

    public FilesDeleteHeaders setXMsLinkCount(Long xMsLinkCount) {
        this.xMsLinkCount = xMsLinkCount;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public FilesDeleteHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public FilesDeleteHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

