/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class SharesCreateHeaders {
    private Long xMsShareProvisionedBandwidthMibps;
    private Long xMsShareProvisionedIops;
    private Long xMsShareIncludedBurstIops;
    private String xMsVersion;
    private Long xMsShareQuota;
    private String eTag;
    private DateTimeRfc1123 lastModified;
    private Long xMsShareMaxBurstCreditsForIops;
    private String xMsRequestId;
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-bandwidth-mibps");
    private static final HttpHeaderName X_MS_SHARE_PROVISIONED_IOPS = HttpHeaderName.fromString((String)"x-ms-share-provisioned-iops");
    private static final HttpHeaderName X_MS_SHARE_INCLUDED_BURST_IOPS = HttpHeaderName.fromString((String)"x-ms-share-included-burst-iops");
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_SHARE_QUOTA = HttpHeaderName.fromString((String)"x-ms-share-quota");
    private static final HttpHeaderName X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS = HttpHeaderName.fromString((String)"x-ms-share-max-burst-credits-for-iops");

    public SharesCreateHeaders(HttpHeaders rawHeaders) {
        String xMsShareProvisionedBandwidthMibps = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_BANDWIDTH_MIBPS);
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps != null ? Long.valueOf(Long.parseLong(xMsShareProvisionedBandwidthMibps)) : null;
        String xMsShareProvisionedIops = rawHeaders.getValue(X_MS_SHARE_PROVISIONED_IOPS);
        this.xMsShareProvisionedIops = xMsShareProvisionedIops != null ? Long.valueOf(Long.parseLong(xMsShareProvisionedIops)) : null;
        String xMsShareIncludedBurstIops = rawHeaders.getValue(X_MS_SHARE_INCLUDED_BURST_IOPS);
        this.xMsShareIncludedBurstIops = xMsShareIncludedBurstIops != null ? Long.valueOf(Long.parseLong(xMsShareIncludedBurstIops)) : null;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsShareQuota = rawHeaders.getValue(X_MS_SHARE_QUOTA);
        this.xMsShareQuota = xMsShareQuota != null ? Long.valueOf(Long.parseLong(xMsShareQuota)) : null;
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        String xMsShareMaxBurstCreditsForIops = rawHeaders.getValue(X_MS_SHARE_MAX_BURST_CREDITS_FOR_IOPS);
        this.xMsShareMaxBurstCreditsForIops = xMsShareMaxBurstCreditsForIops != null ? Long.valueOf(Long.parseLong(xMsShareMaxBurstCreditsForIops)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
    }

    public Long getXMsShareProvisionedBandwidthMibps() {
        return this.xMsShareProvisionedBandwidthMibps;
    }

    public SharesCreateHeaders setXMsShareProvisionedBandwidthMibps(Long xMsShareProvisionedBandwidthMibps) {
        this.xMsShareProvisionedBandwidthMibps = xMsShareProvisionedBandwidthMibps;
        return this;
    }

    public Long getXMsShareProvisionedIops() {
        return this.xMsShareProvisionedIops;
    }

    public SharesCreateHeaders setXMsShareProvisionedIops(Long xMsShareProvisionedIops) {
        this.xMsShareProvisionedIops = xMsShareProvisionedIops;
        return this;
    }

    public Long getXMsShareIncludedBurstIops() {
        return this.xMsShareIncludedBurstIops;
    }

    public SharesCreateHeaders setXMsShareIncludedBurstIops(Long xMsShareIncludedBurstIops) {
        this.xMsShareIncludedBurstIops = xMsShareIncludedBurstIops;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public SharesCreateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Long getXMsShareQuota() {
        return this.xMsShareQuota;
    }

    public SharesCreateHeaders setXMsShareQuota(Long xMsShareQuota) {
        this.xMsShareQuota = xMsShareQuota;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SharesCreateHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public SharesCreateHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Long getXMsShareMaxBurstCreditsForIops() {
        return this.xMsShareMaxBurstCreditsForIops;
    }

    public SharesCreateHeaders setXMsShareMaxBurstCreditsForIops(Long xMsShareMaxBurstCreditsForIops) {
        this.xMsShareMaxBurstCreditsForIops = xMsShareMaxBurstCreditsForIops;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public SharesCreateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public SharesCreateHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

