/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.util;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.implementation.accesshelpers.FilePosixPropertiesHelper;
import com.azure.storage.file.share.implementation.accesshelpers.FileSmbPropertiesHelper;
import com.azure.storage.file.share.implementation.accesshelpers.ShareDirectoryInfoHelper;
import com.azure.storage.file.share.implementation.accesshelpers.ShareDirectoryPropertiesHelper;
import com.azure.storage.file.share.implementation.accesshelpers.ShareFileDownloadHeadersConstructorProxy;
import com.azure.storage.file.share.implementation.accesshelpers.ShareFileInfoHelper;
import com.azure.storage.file.share.implementation.accesshelpers.ShareFilePropertiesHelper;
import com.azure.storage.file.share.implementation.accesshelpers.ShareFileSymbolicLinkInfoHelper;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.FileProperty;
import com.azure.storage.file.share.implementation.models.FilesCreateHardLinkHeaders;
import com.azure.storage.file.share.implementation.models.FilesCreateHeaders;
import com.azure.storage.file.share.implementation.models.FilesCreateSymbolicLinkHeaders;
import com.azure.storage.file.share.implementation.models.FilesDownloadHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.FilesGetSymbolicLinkHeaders;
import com.azure.storage.file.share.implementation.models.FilesSetHttpHeadersHeaders;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLHeaders;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeHeaders;
import com.azure.storage.file.share.implementation.models.HandleItem;
import com.azure.storage.file.share.implementation.models.InternalShareFileItemProperties;
import com.azure.storage.file.share.implementation.models.ListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.ShareItemInternal;
import com.azure.storage.file.share.implementation.models.SharePropertiesInternal;
import com.azure.storage.file.share.implementation.models.ShareStats;
import com.azure.storage.file.share.implementation.models.ShareStorageExceptionInternal;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.StringEncoded;
import com.azure.storage.file.share.models.CopyStatusType;
import com.azure.storage.file.share.models.CopyableFileSmbPropertiesList;
import com.azure.storage.file.share.models.FilePosixProperties;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.NtfsFileAttributes;
import com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.azure.storage.file.share.models.ShareDirectoryProperties;
import com.azure.storage.file.share.models.ShareDirectorySetMetadataInfo;
import com.azure.storage.file.share.models.ShareErrorCode;
import com.azure.storage.file.share.models.ShareFileDownloadHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareFileItemProperties;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileSymbolicLinkInfo;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareInfo;
import com.azure.storage.file.share.models.ShareItem;
import com.azure.storage.file.share.models.ShareProperties;
import com.azure.storage.file.share.models.ShareProtocols;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareSnapshotInfo;
import com.azure.storage.file.share.models.ShareSnapshotsDeleteOptionType;
import com.azure.storage.file.share.models.ShareStatistics;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.options.ShareFileCopyOptions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ModelHelper {
    private static final ClientLogger LOGGER = new ClientLogger(ModelHelper.class);
    private static final long MAX_FILE_PUT_RANGE_BYTES = 0x400000L;
    private static final int FILE_DEFAULT_NUMBER_OF_BUFFERS = 8;
    public static final long FILE_DEFAULT_BLOCK_SIZE = 0x400000L;
    public static final long FILE_MAX_PUT_RANGE_SIZE = 0x400000L;
    private static final HttpHeaderName X_MS_ERROR_CODE = HttpHeaderName.fromString((String)"x-ms-error-code");

    public static ParallelTransferOptions populateAndApplyDefaults(ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize;
        ParallelTransferOptions parallelTransferOptions = other = other == null ? new ParallelTransferOptions() : other;
        if (other.getBlockSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.blockSize", (long)other.getBlockSizeLong(), (long)1L, (long)0x400000L);
        }
        if (other.getMaxSingleUploadSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.maxSingleUploadSize", (long)other.getMaxSingleUploadSizeLong(), (long)1L, (long)0x400000L);
        }
        if ((blockSize = other.getBlockSizeLong()) == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x400000L;
        }
        return new ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressListener(other.getProgressListener()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static DeleteSnapshotsOptionType toDeleteSnapshotsOptionType(ShareSnapshotsDeleteOptionType option) {
        if (option == null) {
            return null;
        }
        switch (option) {
            case INCLUDE: {
                return DeleteSnapshotsOptionType.INCLUDE;
            }
            case INCLUDE_WITH_LEASED: {
                return DeleteSnapshotsOptionType.INCLUDE_LEASED;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid " + ((Object)((Object)option)).getClass()));
    }

    public static ShareItem populateShareItem(ShareItemInternal shareItemInternal) {
        ShareItem item = new ShareItem();
        item.setName(shareItemInternal.getName());
        item.setSnapshot(shareItemInternal.getSnapshot());
        item.setDeleted(shareItemInternal.isDeleted());
        item.setVersion(shareItemInternal.getVersion());
        item.setProperties(ModelHelper.populateShareProperties(shareItemInternal.getProperties()));
        item.setMetadata(shareItemInternal.getMetadata());
        return item;
    }

    public static ShareProperties populateShareProperties(SharePropertiesInternal sharePropertiesInternal) {
        ShareProperties properties = new ShareProperties();
        properties.setLastModified(sharePropertiesInternal.getLastModified());
        properties.setETag(sharePropertiesInternal.getETag());
        properties.setQuota(sharePropertiesInternal.getQuota());
        properties.setProvisionedIops(sharePropertiesInternal.getProvisionedIops());
        properties.setProvisionedIngressMBps(sharePropertiesInternal.getProvisionedIngressMBps());
        properties.setProvisionedEgressMBps(sharePropertiesInternal.getProvisionedEgressMBps());
        properties.setNextAllowedQuotaDowngradeTime(sharePropertiesInternal.getNextAllowedQuotaDowngradeTime());
        properties.setDeletedTime(sharePropertiesInternal.getDeletedTime());
        properties.setRemainingRetentionDays(sharePropertiesInternal.getRemainingRetentionDays());
        properties.setAccessTier(sharePropertiesInternal.getAccessTier());
        properties.setAccessTierChangeTime(sharePropertiesInternal.getAccessTierChangeTime());
        properties.setAccessTierTransitionState(sharePropertiesInternal.getAccessTierTransitionState());
        properties.setLeaseStatus(sharePropertiesInternal.getLeaseStatus());
        properties.setLeaseState(sharePropertiesInternal.getLeaseState());
        properties.setLeaseDuration(sharePropertiesInternal.getLeaseDuration());
        properties.setProtocols(ModelHelper.parseShareProtocols(sharePropertiesInternal.getEnabledProtocols()));
        properties.setRootSquash(sharePropertiesInternal.getRootSquash());
        properties.setMetadata(sharePropertiesInternal.getMetadata());
        properties.setProvisionedBandwidthMiBps(sharePropertiesInternal.getProvisionedBandwidthMiBps());
        properties.setSnapshotVirtualDirectoryAccessEnabled(sharePropertiesInternal.isEnableSnapshotVirtualDirectoryAccess());
        properties.setPaidBurstingEnabled(sharePropertiesInternal.isPaidBurstingEnabled());
        properties.setPaidBurstingMaxIops(sharePropertiesInternal.getPaidBurstingMaxIops());
        properties.setPaidBurstingMaxBandwidthMibps(sharePropertiesInternal.getPaidBurstingMaxBandwidthMibps());
        properties.setIncludedBurstIops(sharePropertiesInternal.getIncludedBurstIops());
        properties.setMaxBurstCreditsForIops(sharePropertiesInternal.getMaxBurstCreditsForIops());
        properties.setNextAllowedProvisionedIopsDowngradeTime(sharePropertiesInternal.getNextAllowedProvisionedIopsDowngradeTime());
        properties.setNextAllowedProvisionedBandwidthDowngradeTime(sharePropertiesInternal.getNextAllowedProvisionedBandwidthDowngradeTime());
        return properties;
    }

    public static ShareProtocols parseShareProtocols(String str) {
        if (str == null) {
            return null;
        }
        ShareProtocols protocols = new ShareProtocols();
        String[] stringArray = str.split(",");
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "SMB": {
                    protocols.setSmbEnabled(true);
                    continue block8;
                }
                case "NFS": {
                    protocols.setNfsEnabled(true);
                    continue block8;
                }
            }
        }
        return protocols;
    }

    public static ServicesListSharesSegmentHeaders transformListSharesHeaders(HttpHeaders headers) {
        if (headers == null) {
            return null;
        }
        return new ServicesListSharesSegmentHeaders(headers);
    }

    public static ShareFileDownloadHeaders transformFileDownloadHeaders(FilesDownloadHeaders headers, HttpHeaders rawHeaders) {
        if (headers == null) {
            return null;
        }
        return ShareFileDownloadHeadersConstructorProxy.create(headers).setErrorCode(rawHeaders.getValue(X_MS_ERROR_CODE));
    }

    public static String getETag(HttpHeaders headers) {
        return headers.getValue(HttpHeaderName.ETAG);
    }

    public static ShareFileItemProperties transformFileProperty(FileProperty property) {
        if (property == null) {
            return null;
        }
        return new InternalShareFileItemProperties(property.getCreationTime(), property.getLastAccessTime(), property.getLastWriteTime(), property.getChangeTime(), property.getLastModified(), property.getEtag());
    }

    public static com.azure.storage.file.share.models.HandleItem transformHandleItem(HandleItem handleItem) {
        return new com.azure.storage.file.share.models.HandleItem().setHandleId(handleItem.getHandleId()).setPath(ModelHelper.decodeName(handleItem.getPath())).setSessionId(handleItem.getSessionId()).setClientIp(handleItem.getClientIp()).setFileId(handleItem.getFileId()).setParentId(handleItem.getParentId()).setLastReconnectTime(handleItem.getLastReconnectTime()).setOpenTime(handleItem.getOpenTime()).setAccessRights(handleItem.getAccessRightList()).setClientName(handleItem.getClientName());
    }

    public static List<com.azure.storage.file.share.models.HandleItem> transformHandleItems(List<HandleItem> handleItems) {
        ArrayList<com.azure.storage.file.share.models.HandleItem> result = new ArrayList<com.azure.storage.file.share.models.HandleItem>();
        handleItems.forEach(item -> result.add(ModelHelper.transformHandleItem(item)));
        return result;
    }

    public static String decodeName(StringEncoded stringEncoded) {
        if (stringEncoded.isEncoded() != null && stringEncoded.isEncoded().booleanValue()) {
            try {
                return URLDecoder.decode(stringEncoded.getContent(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
            }
        }
        return stringEncoded.getContent();
    }

    public static void validateFilePermissionAndKey(String filePermission, String filePermissionKey) {
        if (filePermission != null && filePermissionKey != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("File permission and file permission key cannot both be set"));
        }
        if (filePermission != null) {
            StorageImplUtils.assertInBounds((String)"filePermission", (long)filePermission.getBytes(StandardCharsets.UTF_8).length, (long)0L, (long)8192L);
        }
    }

    public static boolean checkDoesNotExistStatusCode(Throwable t) {
        if (t instanceof ShareStorageException) {
            ShareStorageException s = (ShareStorageException)((Object)t);
            return s.getStatusCode() == 404 && (s.getErrorCode() == ShareErrorCode.RESOURCE_NOT_FOUND || s.getErrorCode() == ShareErrorCode.SHARE_NOT_FOUND);
        }
        if (t instanceof HttpResponseException) {
            HttpResponseException h = (HttpResponseException)t;
            String errorCode = h.getResponse().getHeaderValue(X_MS_ERROR_CODE);
            return h.getResponse().getStatusCode() == 404 && (ShareErrorCode.RESOURCE_NOT_FOUND.toString().equals(errorCode) || ShareErrorCode.SHARE_NOT_FOUND.toString().equals(errorCode));
        }
        return false;
    }

    public static Response<ShareFileInfo> createFileInfoResponse(ResponseBase<FilesCreateHeaders, Void> response) {
        String eTag = ((FilesCreateHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FilesCreateHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((FilesCreateHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareFileInfo shareFileInfo = ShareFileInfoHelper.create(eTag, lastModified, isServerEncrypted, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareFileInfo);
    }

    public static Response<ShareFileProperties> getPropertiesResponse(ResponseBase<FilesGetPropertiesHeaders, Void> response) {
        FilesGetPropertiesHeaders headers = (FilesGetPropertiesHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        Map<String, String> metadata = headers.getXMsMeta();
        String fileType = headers.getXMsType();
        Long contentLength = headers.getContentLength();
        String contentType = headers.getContentType();
        byte[] contentMD5 = headers.getContentMD5();
        String contentEncoding = headers.getContentEncoding();
        String cacheControl = headers.getCacheControl();
        String contentDisposition = headers.getContentDisposition();
        LeaseStatusType leaseStatusType = headers.getXMsLeaseStatus();
        LeaseStateType leaseStateType = headers.getXMsLeaseState();
        LeaseDurationType leaseDurationType = headers.getXMsLeaseDuration();
        OffsetDateTime copyCompletionTime = headers.getXMsCopyCompletionTime();
        String copyStatusDescription = headers.getXMsCopyStatusDescription();
        String copyId = headers.getXMsCopyId();
        String copyProgress = headers.getXMsCopyProgress();
        String copySource = headers.getXMsCopySource();
        CopyStatusType copyStatus = headers.getXMsCopyStatus();
        Boolean isServerEncrypted = headers.isXMsServerEncrypted();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareFileProperties shareFileProperties = ShareFilePropertiesHelper.create(eTag, lastModified, metadata, fileType, contentLength, contentType, contentMD5, contentEncoding, cacheControl, contentDisposition, leaseStatusType, leaseStateType, leaseDurationType, copyCompletionTime, copyStatusDescription, copyId, copyProgress, copySource, copyStatus, isServerEncrypted, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareFileProperties);
    }

    public static Response<ShareFileInfo> setPropertiesResponse(ResponseBase<FilesSetHttpHeadersHeaders, Void> response) {
        String eTag = ((FilesSetHttpHeadersHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FilesSetHttpHeadersHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((FilesSetHttpHeadersHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareFileInfo shareFileInfo = ShareFileInfoHelper.create(eTag, lastModified, isServerEncrypted, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareFileInfo);
    }

    public static Response<ShareFileMetadataInfo> setMetadataResponse(ResponseBase<FilesSetMetadataHeaders, Void> response) {
        String eTag = ((FilesSetMetadataHeaders)response.getDeserializedHeaders()).getETag();
        Boolean isServerEncrypted = ((FilesSetMetadataHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted();
        ShareFileMetadataInfo shareFileMetadataInfo = new ShareFileMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse(response, (Object)shareFileMetadataInfo);
    }

    public static void validateCopyFlagAndSmbProperties(ShareFileCopyOptions options, FileSmbProperties tempSmbProperties) {
        CopyableFileSmbPropertiesList list;
        CopyableFileSmbPropertiesList copyableFileSmbPropertiesList = list = options.getSmbPropertiesToCopy() == null ? new CopyableFileSmbPropertiesList() : options.getSmbPropertiesToCopy();
        if (list.isFileAttributes().booleanValue() && tempSmbProperties.getNtfsFileAttributes() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetFileAttributes and smbProperties.ntfsFileAttributes cannot be set."));
        }
        if (list.isCreatedOn().booleanValue() && tempSmbProperties.getFileCreationTime() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetCreatedOn and smbProperties.fileCreationTime cannot be set."));
        }
        if (list.isLastWrittenOn().booleanValue() && tempSmbProperties.getFileLastWriteTime() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetLastWrittenOn and smbProperties.fileLastWriteTime cannot be set."));
        }
        if (list.isChangedOn().booleanValue() && tempSmbProperties.getFileChangeTime() != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both CopyableFileSmbPropertiesList.isSetChangedOn and smbProperties.fileChangeTime cannot be set."));
        }
    }

    public static Response<ShareFileUploadInfo> transformUploadResponse(ResponseBase<FilesUploadRangeHeaders, Void> response) {
        FilesUploadRangeHeaders headers = (FilesUploadRangeHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        byte[] contentMD5 = headers.getContentMD5();
        Boolean isServerEncrypted = headers.isXMsRequestServerEncrypted();
        ShareFileUploadInfo shareFileUploadInfo = new ShareFileUploadInfo(eTag, lastModified, contentMD5, isServerEncrypted);
        return new SimpleResponse(response, (Object)shareFileUploadInfo);
    }

    public static Response<ShareInfo> mapToShareInfoResponse(Response<?> response) {
        String eTag = ModelHelper.getETag(response.getHeaders());
        OffsetDateTime lastModified = new DateTimeRfc1123(response.getHeaders().getValue(HttpHeaderName.LAST_MODIFIED)).getDateTime();
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new ShareInfo(eTag, lastModified));
    }

    public static Response<ShareProperties> mapGetPropertiesResponse(ResponseBase<SharesGetPropertiesHeaders, Void> response) {
        SharesGetPropertiesHeaders headers = (SharesGetPropertiesHeaders)response.getDeserializedHeaders();
        ShareProperties shareProperties = new ShareProperties().setETag(headers.getETag()).setLastModified(headers.getLastModified()).setMetadata(headers.getXMsMeta()).setQuota(headers.getXMsShareQuota()).setNextAllowedQuotaDowngradeTime(headers.getXMsShareNextAllowedQuotaDowngradeTime()).setProvisionedEgressMBps(headers.getXMsShareProvisionedEgressMbps()).setProvisionedIngressMBps(headers.getXMsShareProvisionedIngressMbps()).setProvisionedBandwidthMiBps(headers.getXMsShareProvisionedBandwidthMibps()).setProvisionedIops(headers.getXMsShareProvisionedIops()).setLeaseDuration(headers.getXMsLeaseDuration()).setLeaseState(headers.getXMsLeaseState()).setLeaseStatus(headers.getXMsLeaseStatus()).setAccessTier(headers.getXMsAccessTier()).setAccessTierChangeTime(headers.getXMsAccessTierChangeTime()).setAccessTierTransitionState(headers.getXMsAccessTierTransitionState()).setProtocols(ModelHelper.parseShareProtocols(headers.getXMsEnabledProtocols())).setSnapshotVirtualDirectoryAccessEnabled(headers.isXMsEnableSnapshotVirtualDirectoryAccess()).setPaidBurstingEnabled(headers.isXMsSharePaidBurstingEnabled()).setPaidBurstingMaxIops(headers.getXMsSharePaidBurstingMaxIops()).setPaidBurstingMaxBandwidthMibps(headers.getXMsSharePaidBurstingMaxBandwidthMibps()).setRootSquash(headers.getXMsRootSquash()).setIncludedBurstIops(headers.getXMsShareIncludedBurstIops()).setMaxBurstCreditsForIops(headers.getXMsShareMaxBurstCreditsForIops()).setNextAllowedProvisionedIopsDowngradeTime(headers.getXMsShareNextAllowedProvisionedIopsDowngradeTime()).setNextAllowedProvisionedBandwidthDowngradeTime(headers.getXMsShareNextAllowedProvisionedBandwidthDowngradeTime());
        return new SimpleResponse(response, (Object)shareProperties);
    }

    public static Response<ShareStatistics> mapGetStatisticsResponse(Response<ShareStats> response) {
        return new SimpleResponse(response, (Object)new ShareStatistics(((ShareStats)response.getValue()).getShareUsageBytes()));
    }

    public static Response<ShareFileUploadInfo> uploadRangeHeadersToShareFileInfo(ResponseBase<FilesUploadRangeHeaders, Void> response) {
        FilesUploadRangeHeaders headers = (FilesUploadRangeHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        byte[] contentMD5 = headers.getContentMD5();
        Boolean isServerEncrypted = headers.isXMsRequestServerEncrypted();
        ShareFileUploadInfo shareFileUploadInfo = new ShareFileUploadInfo(eTag, lastModified, contentMD5, isServerEncrypted);
        return new SimpleResponse(response, (Object)shareFileUploadInfo);
    }

    public static Response<ShareFileUploadRangeFromUrlInfo> mapUploadRangeFromUrlResponse(ResponseBase<FilesUploadRangeFromURLHeaders, Void> response) {
        FilesUploadRangeFromURLHeaders headers = (FilesUploadRangeFromURLHeaders)response.getDeserializedHeaders();
        String eTag = headers.getETag();
        OffsetDateTime lastModified = headers.getLastModified();
        Boolean isServerEncrypted = headers.isXMsRequestServerEncrypted();
        ShareFileUploadRangeFromUrlInfo shareFileUploadRangeFromUrlInfo = new ShareFileUploadRangeFromUrlInfo(eTag, lastModified, isServerEncrypted);
        return new SimpleResponse(response, (Object)shareFileUploadRangeFromUrlInfo);
    }

    public static Response<ShareSnapshotInfo> mapCreateSnapshotResponse(ResponseBase<SharesCreateSnapshotHeaders, Void> response) {
        SharesCreateSnapshotHeaders headers = (SharesCreateSnapshotHeaders)response.getDeserializedHeaders();
        ShareSnapshotInfo snapshotInfo = new ShareSnapshotInfo(headers.getXMsSnapshot(), headers.getETag(), headers.getLastModified());
        return new SimpleResponse(response, (Object)snapshotInfo);
    }

    public static Response<ShareDirectoryInfo> mapShareDirectoryInfo(ResponseBase<DirectoriesCreateHeaders, Void> response) {
        String eTag = ((DirectoriesCreateHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((DirectoriesCreateHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareDirectoryInfo shareDirectoryInfo = ShareDirectoryInfoHelper.create(eTag, lastModified, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareDirectoryInfo);
    }

    public static Response<ShareDirectoryProperties> mapShareDirectoryPropertiesResponse(ResponseBase<DirectoriesGetPropertiesHeaders, Void> response) {
        Map<String, String> metadata = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).getXMsMeta();
        String eTag = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime offsetDateTime = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).getLastModified();
        boolean isServerEncrypted = ((DirectoriesGetPropertiesHeaders)response.getDeserializedHeaders()).isXMsServerEncrypted();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareDirectoryProperties shareDirectoryProperties = ShareDirectoryPropertiesHelper.create(metadata, eTag, offsetDateTime, isServerEncrypted, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareDirectoryProperties);
    }

    public static Response<ShareDirectoryInfo> mapSetPropertiesResponse(ResponseBase<DirectoriesSetPropertiesHeaders, Void> response) {
        String eTag = ((DirectoriesSetPropertiesHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((DirectoriesSetPropertiesHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareDirectoryInfo shareDirectoryInfo = ShareDirectoryInfoHelper.create(eTag, lastModified, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareDirectoryInfo);
    }

    public static Response<ShareDirectorySetMetadataInfo> setShareDirectoryMetadataResponse(ResponseBase<DirectoriesSetMetadataHeaders, Void> response) {
        String eTag = ((DirectoriesSetMetadataHeaders)response.getDeserializedHeaders()).getETag();
        boolean isServerEncrypted = ((DirectoriesSetMetadataHeaders)response.getDeserializedHeaders()).isXMsRequestServerEncrypted();
        ShareDirectorySetMetadataInfo shareDirectorySetMetadataInfo = new ShareDirectorySetMetadataInfo(eTag, isServerEncrypted);
        return new SimpleResponse(response, (Object)shareDirectorySetMetadataInfo);
    }

    public static List<ShareFileItem> convertResponseAndGetNumOfResults(Response<ListFilesAndDirectoriesSegmentResponse> res) {
        TreeSet<ShareFileItem> shareFileItems = new TreeSet<ShareFileItem>(Comparator.comparing(ShareFileItem::getName));
        if (((ListFilesAndDirectoriesSegmentResponse)res.getValue()).getSegment() != null) {
            ((ListFilesAndDirectoriesSegmentResponse)res.getValue()).getSegment().getDirectoryItems().forEach(directoryItem -> shareFileItems.add(new ShareFileItem(ModelHelper.decodeName(directoryItem.getName()), true, directoryItem.getFileId(), ModelHelper.transformFileProperty(directoryItem.getProperties()), NtfsFileAttributes.toAttributes(directoryItem.getAttributes()), directoryItem.getPermissionKey(), null)));
            ((ListFilesAndDirectoriesSegmentResponse)res.getValue()).getSegment().getFileItems().forEach(fileItem -> shareFileItems.add(new ShareFileItem(ModelHelper.decodeName(fileItem.getName()), false, fileItem.getFileId(), ModelHelper.transformFileProperty(fileItem.getProperties()), NtfsFileAttributes.toAttributes(fileItem.getAttributes()), fileItem.getPermissionKey(), fileItem.getProperties().getContentLength())));
        }
        return new ArrayList<ShareFileItem>(shareFileItems);
    }

    public static Response<ShareFileInfo> createHardLinkResponse(ResponseBase<FilesCreateHardLinkHeaders, Void> response) {
        String eTag = ((FilesCreateHardLinkHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FilesCreateHardLinkHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareFileInfo shareFileInfo = ShareFileInfoHelper.create(eTag, lastModified, null, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareFileInfo);
    }

    public static Response<ShareFileInfo> createSymbolicLinkResponse(ResponseBase<FilesCreateSymbolicLinkHeaders, Void> response) {
        String eTag = ((FilesCreateSymbolicLinkHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FilesCreateSymbolicLinkHeaders)response.getDeserializedHeaders()).getLastModified();
        FileSmbProperties smbProperties = FileSmbPropertiesHelper.create(response.getHeaders());
        FilePosixProperties posixProperties = FilePosixPropertiesHelper.create(response.getHeaders());
        ShareFileInfo shareFileInfo = ShareFileInfoHelper.create(eTag, lastModified, null, smbProperties, posixProperties);
        return new SimpleResponse(response, (Object)shareFileInfo);
    }

    public static Response<ShareFileSymbolicLinkInfo> getSymbolicLinkResponse(ResponseBase<FilesGetSymbolicLinkHeaders, Void> response) {
        String eTag = ((FilesGetSymbolicLinkHeaders)response.getDeserializedHeaders()).getETag();
        OffsetDateTime lastModified = ((FilesGetSymbolicLinkHeaders)response.getDeserializedHeaders()).getLastModified();
        String linkText = ((FilesGetSymbolicLinkHeaders)response.getDeserializedHeaders()).getXMsLinkText();
        ShareFileSymbolicLinkInfo shareFileSymbolicLinkInfo = ShareFileSymbolicLinkInfoHelper.create(eTag, lastModified, linkText);
        return new SimpleResponse(response, (Object)shareFileSymbolicLinkInfo);
    }

    public static List<ShareSignedIdentifier> truncateAccessPolicyPermissionsToSeconds(List<ShareSignedIdentifier> permissions) {
        if (permissions != null) {
            for (ShareSignedIdentifier permission : permissions) {
                if (permission.getAccessPolicy() != null && permission.getAccessPolicy().getStartsOn() != null) {
                    permission.getAccessPolicy().setStartsOn(permission.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
                }
                if (permission.getAccessPolicy() == null || permission.getAccessPolicy().getExpiresOn() == null) continue;
                permission.getAccessPolicy().setExpiresOn(permission.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        return permissions;
    }

    public static LongRunningOperationStatus mapStatusToLongRunningOperationStatus(CopyStatusType status) {
        LongRunningOperationStatus operationStatus;
        switch (status) {
            case SUCCESS: {
                operationStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                operationStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case ABORTED: {
                operationStatus = LongRunningOperationStatus.USER_CANCELLED;
                break;
            }
            case PENDING: {
                operationStatus = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("CopyStatusType is not supported. Status: " + (Object)((Object)status)));
            }
        }
        return operationStatus;
    }

    public static ShareStorageException mapToShareStorageException(ShareStorageExceptionInternal internal) {
        String code = internal.getValue() == null ? null : internal.getValue().getCode();
        String headerName = internal.getValue() == null ? null : internal.getValue().getHeaderName();
        return new ShareStorageException(StorageImplUtils.convertStorageExceptionMessage((String)internal.getMessage(), (HttpResponse)internal.getResponse(), (String)code, (String)headerName), internal.getResponse(), internal.getValue());
    }
}

