/*
 * Decompiled with CFR 0.152.
 */
package com.gavinmogan;

import com.codacy.api.CoverageReport;
import com.codacy.api.helpers.vcs.GitClient;
import com.codacy.parsers.implementation.CoberturaParser;
import com.codacy.parsers.implementation.JacocoParser;
import com.codacy.transformation.PathPrefixer;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import play.api.libs.json.Json;
import play.api.libs.json.Writes;
import scala.util.Either;

@Mojo(name="coverage", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class CodacyCoverageReporterMojo
extends AbstractMojo {
    private static Class[] parsers = new Class[]{CoberturaParser.class, JacocoParser.class};
    @Parameter(defaultValue="${env.CODACY_PROJECT_TOKEN}", property="projectToken", required=true)
    private String projectToken;
    @Parameter(defaultValue="${env.CODACY_API_TOKEN}", property="apiToken", required=true)
    private String apiToken;
    @Parameter(defaultValue="Java", property="language", required=true)
    private String language;
    @Parameter(defaultValue="${env.CI_COMMIT}", property="commit", required=false)
    private String commit;
    @Parameter(defaultValue="", property="coverageReportFile", required=true)
    private File coverageReportFile;
    @Parameter(defaultValue="${project.basedir}", property="rootProjectDir", required=true)
    private File rootProjectDir;
    @Parameter(defaultValue="", property="prefix", required=false)
    private String prefix;
    @Parameter(defaultValue="${env.CODACY_API_BASE_URL}", property="codacyApiBaseUrl", required=false)
    private String codacyApiBaseUrl;
    @Parameter(defaultValue="true", property="failOnMissingReportFile", required=false)
    private boolean failOnMissingReportFile;
    @Parameter(defaultValue="false", property="codacy.trustSelfSignedCerts", required=false)
    private boolean trustSelfSignedCerts;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (!this.coverageReportFile.exists()) {
            if (this.failOnMissingReportFile) {
                throw new MojoFailureException("Report file does not exist");
            }
            this.getLog().warn((CharSequence)"Report file does not exist");
            return;
        }
        if (Strings.isNullOrEmpty((String)this.commit)) {
            GitClient gitClient = new GitClient(this.rootProjectDir);
            this.commit = (String)gitClient.latestCommitUuid().get();
        }
        if (Strings.isNullOrEmpty((String)this.codacyApiBaseUrl)) {
            this.codacyApiBaseUrl = "https://api.codacy.com";
        }
        this.getLog().debug((CharSequence)("Project token: " + this.projectToken));
        this.getLog().info((CharSequence)("Parsing coverage data... " + this.coverageReportFile));
        CoverageReport report = CodacyCoverageReporterMojo.processReport(this.rootProjectDir, this.coverageReportFile);
        if (!Strings.isNullOrEmpty((String)this.prefix)) {
            PathPrefixer pathPrefixer = new PathPrefixer(this.prefix);
            report = pathPrefixer.execute(report);
        }
        try {
            this.getLog().info((CharSequence)"Uploading coverage data...");
            this.postReport(report);
            this.getLog().info((CharSequence)"Coverage data uploaded");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            this.getLog().error((CharSequence)"Failed to upload coverage data.", (Throwable)e);
            throw new MojoFailureException("Failed to upload coverage data. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public String postReport(CoverageReport report) throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        try (CloseableHttpClient httpclient = this.createHttpClient();){
            HttpPost httppost = new HttpPost(this.codacyApiBaseUrl + "/2.0/coverage/" + this.commit + "/" + this.language.toLowerCase());
            httppost.setHeader("api_token", this.apiToken);
            httppost.setHeader("project_token", this.projectToken);
            httppost.setHeader("Content-Type", "application/json");
            String json = Json.toJson((Object)report, (Writes)CoverageReport.coverageReportWrites()).toString();
            StringEntity input = new StringEntity(json);
            input.setContentType("application/json");
            httppost.setEntity((HttpEntity)input);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String string = (String)httpclient.execute((HttpUriRequest)httppost, (ResponseHandler)responseHandler);
            return string;
        }
    }

    private CloseableHttpClient createHttpClient() throws IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        if (this.trustSelfSignedCerts) {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        HttpClientBuilder builder = HttpClients.custom();
        return builder.build();
    }

    private SSLContext createSSLContext() throws IOException {
        try {
            return SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IOException("Could not create SSL context: " + e.getMessage(), e);
        }
    }

    public static CoverageReport processReport(File rootProject, File reportFile) {
        for (Class clazz : parsers) {
            try {
                Either result = (Either)clazz.getMethod("parse", File.class, File.class).invoke(null, rootProject, reportFile);
                if (!result.isRight()) continue;
                return (CoverageReport)result.right().get();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setCoverageReportFile(File coverageReportFile) {
        this.coverageReportFile = coverageReportFile;
    }

    public void setProjectToken(String projectToken) {
        this.projectToken = projectToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setRootProjectDir(File rootProjectDir) {
        this.rootProjectDir = rootProjectDir;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setCodacyApiBaseUrl(String codacyApiBaseUrl) {
        this.codacyApiBaseUrl = codacyApiBaseUrl;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public void setFailOnMissingReportFile(boolean failOnMissingReportFile) {
        this.failOnMissingReportFile = failOnMissingReportFile;
    }

    public void setTrustSelfSignedCerts(boolean trustSelfSignedCerts) {
        this.trustSelfSignedCerts = trustSelfSignedCerts;
    }
}

