/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ExternalDataConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ExternalTableDefinition
extends TableDefinition {
    static final Function<ExternalDataConfiguration, ExternalTableDefinition> FROM_EXTERNAL_DATA_FUNCTION = new Function<ExternalDataConfiguration, ExternalTableDefinition>(){

        public ExternalTableDefinition apply(ExternalDataConfiguration pb) {
            return ExternalTableDefinition.fromExternalDataConfiguration(pb);
        }
    };
    static final Function<ExternalTableDefinition, ExternalDataConfiguration> TO_EXTERNAL_DATA_FUNCTION = new Function<ExternalTableDefinition, ExternalDataConfiguration>(){

        public ExternalDataConfiguration apply(ExternalTableDefinition tableInfo) {
            return tableInfo.toExternalDataConfigurationPb();
        }
    };
    private static final long serialVersionUID = -5951580238459622025L;
    private final List<String> sourceUris;
    private final FormatOptions formatOptions;
    private final Integer maxBadRecords;
    private final Boolean ignoreUnknownValues;
    private final String compression;
    private final Boolean autodetect;

    private ExternalTableDefinition(Builder builder) {
        super(builder);
        this.compression = builder.compression;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.maxBadRecords = builder.maxBadRecords;
        this.formatOptions = builder.formatOptions;
        this.sourceUris = builder.sourceUris;
        this.autodetect = builder.autodetect;
    }

    public String getCompression() {
        return this.compression;
    }

    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    public Integer getMaxBadRecords() {
        return this.maxBadRecords;
    }

    public List<String> getSourceUris() {
        return this.sourceUris;
    }

    public <F extends FormatOptions> F getFormatOptions() {
        return (F)this.formatOptions;
    }

    public Boolean getAutodetect() {
        return this.autodetect;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sourceUris", this.sourceUris).add("formatOptions", (Object)this.formatOptions).add("compression", (Object)this.compression).add("ignoreUnknownValues", (Object)this.ignoreUnknownValues).add("maxBadRecords", (Object)this.maxBadRecords).add("autodetect", (Object)this.autodetect);
    }

    public final boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(ExternalTableDefinition.class) && this.baseEquals((ExternalTableDefinition)obj);
    }

    public final int hashCode() {
        return Objects.hash(this.baseHashCode(), this.compression, this.ignoreUnknownValues, this.maxBadRecords, this.formatOptions, this.sourceUris, this.autodetect);
    }

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        tablePb.setExternalDataConfiguration(this.toExternalDataConfigurationPb());
        return tablePb;
    }

    ExternalDataConfiguration toExternalDataConfigurationPb() {
        ExternalDataConfiguration externalConfigurationPb = new ExternalDataConfiguration();
        if (this.compression != null) {
            externalConfigurationPb.setCompression(this.compression);
        }
        if (this.ignoreUnknownValues != null) {
            externalConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        }
        if (this.maxBadRecords != null) {
            externalConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        }
        if (this.getSchema() != null) {
            externalConfigurationPb.setSchema(this.getSchema().toPb());
        }
        if (this.formatOptions != null) {
            externalConfigurationPb.setSourceFormat(this.formatOptions.getType());
        }
        if (this.sourceUris != null) {
            externalConfigurationPb.setSourceUris(this.sourceUris);
        }
        if (this.formatOptions != null && "CSV".equals(this.formatOptions.getType())) {
            externalConfigurationPb.setCsvOptions(((CsvOptions)this.formatOptions).toPb());
        }
        if (this.autodetect != null) {
            externalConfigurationPb.setAutodetect(this.autodetect);
        }
        return externalConfigurationPb;
    }

    public static Builder newBuilder(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ((Builder)new Builder().setSourceUris(sourceUris).setSchema(schema)).setFormatOptions(format);
    }

    public static Builder newBuilder(String sourceUri, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder((List<String>)ImmutableList.of((Object)sourceUri), schema, format);
    }

    public static ExternalTableDefinition of(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUris, schema, format).build();
    }

    public static ExternalTableDefinition of(String sourceUri, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUri, schema, format).build();
    }

    static ExternalTableDefinition fromPb(Table tablePb) {
        return new Builder(tablePb).build();
    }

    static ExternalTableDefinition fromExternalDataConfiguration(ExternalDataConfiguration externalDataConfiguration) {
        Builder builder = new Builder();
        if (externalDataConfiguration.getSourceUris() != null) {
            builder.setSourceUris(externalDataConfiguration.getSourceUris());
        }
        if (externalDataConfiguration.getSchema() != null) {
            builder.setSchema(Schema.fromPb(externalDataConfiguration.getSchema()));
        }
        if (externalDataConfiguration.getSourceFormat() != null) {
            builder.setFormatOptions(FormatOptions.of(externalDataConfiguration.getSourceFormat()));
        }
        if (externalDataConfiguration.getCompression() != null) {
            builder.setCompression(externalDataConfiguration.getCompression());
        }
        if (externalDataConfiguration.getIgnoreUnknownValues() != null) {
            builder.setIgnoreUnknownValues(externalDataConfiguration.getIgnoreUnknownValues());
        }
        if (externalDataConfiguration.getCsvOptions() != null) {
            builder.setFormatOptions(CsvOptions.fromPb(externalDataConfiguration.getCsvOptions()));
        }
        if (externalDataConfiguration.getMaxBadRecords() != null) {
            builder.setMaxBadRecords(externalDataConfiguration.getMaxBadRecords());
        }
        if (externalDataConfiguration.getAutodetect() != null) {
            builder.setAutodetect(externalDataConfiguration.getAutodetect());
        }
        return builder.build();
    }

    public static final class Builder
    extends TableDefinition.Builder<ExternalTableDefinition, Builder> {
        private List<String> sourceUris;
        private FormatOptions formatOptions;
        private Integer maxBadRecords;
        private Boolean ignoreUnknownValues;
        private String compression;
        private Boolean autodetect;

        private Builder() {
            super(TableDefinition.Type.EXTERNAL);
        }

        private Builder(ExternalTableDefinition tableDefinition) {
            super(tableDefinition);
            this.sourceUris = tableDefinition.sourceUris;
            this.formatOptions = tableDefinition.formatOptions;
            this.maxBadRecords = tableDefinition.maxBadRecords;
            this.ignoreUnknownValues = tableDefinition.ignoreUnknownValues;
            this.compression = tableDefinition.compression;
            this.autodetect = tableDefinition.autodetect;
        }

        private Builder(Table tablePb) {
            super(tablePb);
            ExternalDataConfiguration externalDataConfiguration = tablePb.getExternalDataConfiguration();
            if (externalDataConfiguration != null) {
                if (externalDataConfiguration.getSourceUris() != null) {
                    this.sourceUris = ImmutableList.copyOf((Collection)externalDataConfiguration.getSourceUris());
                }
                if (externalDataConfiguration.getSourceFormat() != null) {
                    this.formatOptions = FormatOptions.of(externalDataConfiguration.getSourceFormat());
                }
                this.compression = externalDataConfiguration.getCompression();
                this.ignoreUnknownValues = externalDataConfiguration.getIgnoreUnknownValues();
                if (externalDataConfiguration.getCsvOptions() != null) {
                    this.formatOptions = CsvOptions.fromPb(externalDataConfiguration.getCsvOptions());
                }
                this.maxBadRecords = externalDataConfiguration.getMaxBadRecords();
                this.autodetect = externalDataConfiguration.getAutodetect();
            }
        }

        public Builder setSourceUris(List<String> sourceUris) {
            this.sourceUris = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sourceUris)));
            return this;
        }

        public Builder setFormatOptions(FormatOptions formatOptions) {
            this.formatOptions = (FormatOptions)Preconditions.checkNotNull((Object)formatOptions);
            return this;
        }

        public Builder setMaxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        public Builder setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        public Builder setCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Builder setAutodetect(Boolean autodetect) {
            this.autodetect = autodetect;
            return this;
        }

        @Override
        public ExternalTableDefinition build() {
            return new ExternalTableDefinition(this);
        }
    }
}

