/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.core.BetaApi;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@BetaApi
public abstract class WaitForOption
implements Serializable {
    private static final long serialVersionUID = 8443451708032349243L;
    private final OptionType optionType;

    private WaitForOption(OptionType optionType) {
        this.optionType = optionType;
    }

    OptionType getOptionType() {
        return this.optionType;
    }

    final boolean baseEquals(WaitForOption option) {
        return Objects.equals((Object)option.optionType, (Object)option.optionType);
    }

    final int baseHashCode() {
        return Objects.hash(new Object[]{this.optionType});
    }

    private static <T extends WaitForOption> T getOrDefaultInternal(OptionType optionType, T defaultValue, WaitForOption ... options) {
        WaitForOption foundOption = null;
        for (WaitForOption option : options) {
            if (!option.optionType.equals((Object)optionType)) continue;
            Preconditions.checkArgument((foundOption == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
            foundOption = option;
        }
        return (T)(foundOption != null ? foundOption : (WaitForOption)defaultValue);
    }

    public static CheckingPeriod checkEvery(long checkEvery, TimeUnit unit) {
        Preconditions.checkArgument((checkEvery >= 0L ? 1 : 0) != 0, (Object)"checkEvery must be >= 0");
        return new CheckingPeriod(checkEvery, unit);
    }

    public static Timeout timeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be >= 0");
        return new Timeout(unit.toMillis(timeout));
    }

    public static final class Timeout
    extends WaitForOption {
        private static final long serialVersionUID = -7120401111985321932L;
        private static final Timeout DEFAULT = new Timeout(-1L);
        private final long timeoutMillis;

        private Timeout(long timeoutMillis) {
            super(OptionType.TIMEOUT);
            this.timeoutMillis = timeoutMillis;
        }

        public long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Timeout)) {
                return false;
            }
            Timeout other = (Timeout)obj;
            return this.baseEquals(other) && Objects.equals(this.timeoutMillis, other.timeoutMillis);
        }

        public int hashCode() {
            return Objects.hash(this.baseHashCode(), this.timeoutMillis);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("timeoutMillis", this.timeoutMillis).toString();
        }

        public static Timeout getOrDefault(WaitForOption ... options) {
            return (Timeout)WaitForOption.getOrDefaultInternal(OptionType.TIMEOUT, (WaitForOption)Timeout.DEFAULT, options);
        }
    }

    public static final class CheckingPeriod
    extends WaitForOption {
        private static final long serialVersionUID = -2481062893220539210L;
        private static final CheckingPeriod DEFAULT = new CheckingPeriod(500L, TimeUnit.MILLISECONDS);
        private final long period;
        private final TimeUnit unit;

        private CheckingPeriod(long period, TimeUnit unit) {
            super(OptionType.CHECKING_PERIOD);
            this.period = period;
            this.unit = unit;
        }

        public long getPeriod() {
            return this.period;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public void sleep() throws InterruptedException {
            this.unit.sleep(this.period);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof CheckingPeriod)) {
                return false;
            }
            CheckingPeriod other = (CheckingPeriod)obj;
            return this.baseEquals(other) && Objects.equals(this.period, other.period) && Objects.equals((Object)this.unit, (Object)other.unit);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.baseHashCode(), this.period, this.unit});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("period", this.period).add("unit", (Object)this.unit).toString();
        }

        public static CheckingPeriod getOrDefault(WaitForOption ... options) {
            return (CheckingPeriod)WaitForOption.getOrDefaultInternal(OptionType.CHECKING_PERIOD, (WaitForOption)CheckingPeriod.DEFAULT, options);
        }
    }

    static enum OptionType {
        CHECKING_PERIOD,
        TIMEOUT;

    }
}

