/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.errorreporting.spi.v1beta1.ReportErrorsServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.ProjectName;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorEventRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ReportErrorEventResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ReportErrorsServiceClient
implements AutoCloseable {
    private final ReportErrorsServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventCallable;

    public static final ReportErrorsServiceClient create() throws IOException {
        return ReportErrorsServiceClient.create(ReportErrorsServiceSettings.defaultBuilder().build());
    }

    public static final ReportErrorsServiceClient create(ReportErrorsServiceSettings settings) throws IOException {
        return new ReportErrorsServiceClient(settings);
    }

    protected ReportErrorsServiceClient(ReportErrorsServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.reportErrorEventCallable = UnaryCallable.create(settings.reportErrorEventSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ReportErrorsServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ReportErrorsServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final ReportErrorsServiceSettings getSettings() {
        return this.settings;
    }

    public final ReportErrorEventResponse reportErrorEvent(ProjectName projectName, ReportedErrorEvent event) {
        ReportErrorEventRequest request = ReportErrorEventRequest.newBuilder().setProjectNameWithProjectName(projectName).setEvent(event).build();
        return this.reportErrorEvent(request);
    }

    public final ReportErrorEventResponse reportErrorEvent(ReportErrorEventRequest request) {
        return (ReportErrorEventResponse)this.reportErrorEventCallable().call((Object)request);
    }

    public final UnaryCallable<ReportErrorEventRequest, ReportErrorEventResponse> reportErrorEventCallable() {
        return this.reportErrorEventCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

