/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.StorageClass;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class BucketInfo
implements Serializable {
    static final Function<Bucket, BucketInfo> FROM_PB_FUNCTION = new Function<Bucket, BucketInfo>(){

        public BucketInfo apply(Bucket pb) {
            return BucketInfo.fromPb(pb);
        }
    };
    static final Function<BucketInfo, Bucket> TO_PB_FUNCTION = new Function<BucketInfo, Bucket>(){

        public Bucket apply(BucketInfo bucketInfo) {
            return bucketInfo.toPb();
        }
    };
    private static final long serialVersionUID = -4712013629621638459L;
    private final String generatedId;
    private final String name;
    private final Acl.Entity owner;
    private final String selfLink;
    private final Boolean versioningEnabled;
    private final String indexPage;
    private final String notFoundPage;
    private final List<DeleteRule> deleteRules;
    private final String etag;
    private final Long createTime;
    private final Long metageneration;
    private final List<Cors> cors;
    private final List<Acl> acl;
    private final List<Acl> defaultAcl;
    private final String location;
    private final StorageClass storageClass;

    BucketInfo(BuilderImpl builder) {
        this.generatedId = builder.generatedId;
        this.name = builder.name;
        this.etag = builder.etag;
        this.createTime = builder.createTime;
        this.metageneration = builder.metageneration;
        this.location = builder.location;
        this.storageClass = builder.storageClass;
        this.cors = builder.cors;
        this.acl = builder.acl;
        this.defaultAcl = builder.defaultAcl;
        this.owner = builder.owner;
        this.selfLink = builder.selfLink;
        this.versioningEnabled = builder.versioningEnabled;
        this.indexPage = builder.indexPage;
        this.notFoundPage = builder.notFoundPage;
        this.deleteRules = builder.deleteRules;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getName() {
        return this.name;
    }

    public Acl.Entity getOwner() {
        return this.owner;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public Boolean versioningEnabled() {
        return Data.isNull((Object)this.versioningEnabled) ? null : this.versioningEnabled;
    }

    public String getIndexPage() {
        return this.indexPage;
    }

    public String getNotFoundPage() {
        return this.notFoundPage;
    }

    public List<? extends DeleteRule> getDeleteRules() {
        return this.deleteRules;
    }

    public String getEtag() {
        return this.etag;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getMetageneration() {
        return this.metageneration;
    }

    public String getLocation() {
        return this.location;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public List<Cors> getCors() {
        return this.cors;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public List<Acl> getDefaultAcl() {
        return this.defaultAcl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(BucketInfo.class) && Objects.equals(this.toPb(), ((BucketInfo)obj).toPb());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    Bucket toPb() {
        Bucket bucketPb = new Bucket();
        bucketPb.setId(this.generatedId);
        bucketPb.setName(this.name);
        bucketPb.setEtag(this.etag);
        if (this.createTime != null) {
            bucketPb.setTimeCreated(new DateTime(this.createTime.longValue()));
        }
        if (this.metageneration != null) {
            bucketPb.setMetageneration(this.metageneration);
        }
        if (this.location != null) {
            bucketPb.setLocation(this.location);
        }
        if (this.storageClass != null) {
            bucketPb.setStorageClass(this.storageClass.toString());
        }
        if (this.cors != null) {
            bucketPb.setCors(Lists.transform(this.cors, Cors.TO_PB_FUNCTION));
        }
        if (this.acl != null) {
            bucketPb.setAcl(Lists.transform(this.acl, (Function)new Function<Acl, BucketAccessControl>(){

                public BucketAccessControl apply(Acl acl) {
                    return acl.toBucketPb();
                }
            }));
        }
        if (this.defaultAcl != null) {
            bucketPb.setDefaultObjectAcl(Lists.transform(this.defaultAcl, (Function)new Function<Acl, ObjectAccessControl>(){

                public ObjectAccessControl apply(Acl acl) {
                    return acl.toObjectPb();
                }
            }));
        }
        if (this.owner != null) {
            bucketPb.setOwner(new Bucket.Owner().setEntity(this.owner.toPb()));
        }
        bucketPb.setSelfLink(this.selfLink);
        if (this.versioningEnabled != null) {
            bucketPb.setVersioning(new Bucket.Versioning().setEnabled(this.versioningEnabled));
        }
        if (this.indexPage != null || this.notFoundPage != null) {
            Bucket.Website website = new Bucket.Website();
            website.setMainPageSuffix(this.indexPage);
            website.setNotFoundPage(this.notFoundPage);
            bucketPb.setWebsite(website);
        }
        if (this.deleteRules != null) {
            Bucket.Lifecycle lifecycle = new Bucket.Lifecycle();
            lifecycle.setRule(Lists.transform(this.deleteRules, (Function)new Function<DeleteRule, Bucket.Lifecycle.Rule>(){

                public Bucket.Lifecycle.Rule apply(DeleteRule deleteRule) {
                    return deleteRule.toPb();
                }
            }));
            bucketPb.setLifecycle(lifecycle);
        }
        return bucketPb;
    }

    public static BucketInfo of(String name) {
        return BucketInfo.newBuilder(name).build();
    }

    public static Builder newBuilder(String name) {
        return new BuilderImpl(name);
    }

    static BucketInfo fromPb(Bucket bucketPb) {
        Bucket.Website website;
        BuilderImpl builder = new BuilderImpl(bucketPb.getName());
        if (bucketPb.getId() != null) {
            ((Builder)builder).setGeneratedId(bucketPb.getId());
        }
        if (bucketPb.getEtag() != null) {
            ((Builder)builder).setEtag(bucketPb.getEtag());
        }
        if (bucketPb.getMetageneration() != null) {
            ((Builder)builder).setMetageneration(bucketPb.getMetageneration());
        }
        if (bucketPb.getSelfLink() != null) {
            ((Builder)builder).setSelfLink(bucketPb.getSelfLink());
        }
        if (bucketPb.getTimeCreated() != null) {
            ((Builder)builder).setCreateTime(bucketPb.getTimeCreated().getValue());
        }
        if (bucketPb.getLocation() != null) {
            ((Builder)builder).setLocation(bucketPb.getLocation());
        }
        if (bucketPb.getStorageClass() != null) {
            ((Builder)builder).setStorageClass(StorageClass.valueOf(bucketPb.getStorageClass()));
        }
        if (bucketPb.getCors() != null) {
            ((Builder)builder).setCors(Lists.transform((List)bucketPb.getCors(), Cors.FROM_PB_FUNCTION));
        }
        if (bucketPb.getAcl() != null) {
            ((Builder)builder).setAcl(Lists.transform((List)bucketPb.getAcl(), (Function)new Function<BucketAccessControl, Acl>(){

                public Acl apply(BucketAccessControl bucketAccessControl) {
                    return Acl.fromPb(bucketAccessControl);
                }
            }));
        }
        if (bucketPb.getDefaultObjectAcl() != null) {
            ((Builder)builder).setDefaultAcl(Lists.transform((List)bucketPb.getDefaultObjectAcl(), (Function)new Function<ObjectAccessControl, Acl>(){

                public Acl apply(ObjectAccessControl objectAccessControl) {
                    return Acl.fromPb(objectAccessControl);
                }
            }));
        }
        if (bucketPb.getOwner() != null) {
            ((Builder)builder).setOwner(Acl.Entity.fromPb(bucketPb.getOwner().getEntity()));
        }
        if (bucketPb.getVersioning() != null) {
            ((Builder)builder).setVersioningEnabled(bucketPb.getVersioning().getEnabled());
        }
        if ((website = bucketPb.getWebsite()) != null) {
            ((Builder)builder).setIndexPage(website.getMainPageSuffix());
            ((Builder)builder).setNotFoundPage(website.getNotFoundPage());
        }
        if (bucketPb.getLifecycle() != null && bucketPb.getLifecycle().getRule() != null) {
            ((Builder)builder).setDeleteRules(Lists.transform((List)bucketPb.getLifecycle().getRule(), (Function)new Function<Bucket.Lifecycle.Rule, DeleteRule>(){

                public DeleteRule apply(Bucket.Lifecycle.Rule rule) {
                    return DeleteRule.fromPb(rule);
                }
            }));
        }
        return ((Builder)builder).build();
    }

    static final class BuilderImpl
    extends Builder {
        private String generatedId;
        private String name;
        private Acl.Entity owner;
        private String selfLink;
        private Boolean versioningEnabled;
        private String indexPage;
        private String notFoundPage;
        private List<DeleteRule> deleteRules;
        private StorageClass storageClass;
        private String location;
        private String etag;
        private Long createTime;
        private Long metageneration;
        private List<Cors> cors;
        private List<Acl> acl;
        private List<Acl> defaultAcl;

        BuilderImpl(String name) {
            this.name = name;
        }

        BuilderImpl(BucketInfo bucketInfo) {
            this.generatedId = bucketInfo.generatedId;
            this.name = bucketInfo.name;
            this.etag = bucketInfo.etag;
            this.createTime = bucketInfo.createTime;
            this.metageneration = bucketInfo.metageneration;
            this.location = bucketInfo.location;
            this.storageClass = bucketInfo.storageClass;
            this.cors = bucketInfo.cors;
            this.acl = bucketInfo.acl;
            this.defaultAcl = bucketInfo.defaultAcl;
            this.owner = bucketInfo.owner;
            this.selfLink = bucketInfo.selfLink;
            this.versioningEnabled = bucketInfo.versioningEnabled;
            this.indexPage = bucketInfo.indexPage;
            this.notFoundPage = bucketInfo.notFoundPage;
            this.deleteRules = bucketInfo.deleteRules;
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.owner = owner;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setVersioningEnabled(Boolean enable) {
            this.versioningEnabled = (Boolean)MoreObjects.firstNonNull((Object)enable, (Object)Data.nullOf(Boolean.class));
            return this;
        }

        @Override
        public Builder setIndexPage(String indexPage) {
            this.indexPage = indexPage;
            return this;
        }

        @Override
        public Builder setNotFoundPage(String notFoundPage) {
            this.notFoundPage = notFoundPage;
            return this;
        }

        @Override
        public Builder setDeleteRules(Iterable<? extends DeleteRule> rules) {
            this.deleteRules = rules != null ? ImmutableList.copyOf(rules) : null;
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        Builder setCreateTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        @Override
        public Builder setCors(Iterable<Cors> cors) {
            this.cors = cors != null ? ImmutableList.copyOf(cors) : null;
            return this;
        }

        @Override
        public Builder setAcl(Iterable<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        public Builder setDefaultAcl(Iterable<Acl> acl) {
            this.defaultAcl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        public BucketInfo build() {
            Preconditions.checkNotNull((Object)this.name);
            return new BucketInfo(this);
        }
    }

    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setName(String var1);

        abstract Builder setGeneratedId(String var1);

        abstract Builder setOwner(Acl.Entity var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setVersioningEnabled(Boolean var1);

        public abstract Builder setIndexPage(String var1);

        public abstract Builder setNotFoundPage(String var1);

        public abstract Builder setDeleteRules(Iterable<? extends DeleteRule> var1);

        public abstract Builder setStorageClass(StorageClass var1);

        public abstract Builder setLocation(String var1);

        abstract Builder setEtag(String var1);

        abstract Builder setCreateTime(Long var1);

        abstract Builder setMetageneration(Long var1);

        public abstract Builder setCors(Iterable<Cors> var1);

        public abstract Builder setAcl(Iterable<Acl> var1);

        public abstract Builder setDefaultAcl(Iterable<Acl> var1);

        public abstract BucketInfo build();
    }

    public static class IsLiveDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -3502994563121313364L;
        private final boolean isLive;

        public IsLiveDeleteRule(boolean isLive) {
            super(DeleteRule.Type.IS_LIVE);
            this.isLive = isLive;
        }

        public boolean isLive() {
            return this.isLive;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setIsLive(Boolean.valueOf(this.isLive));
        }
    }

    public static class NumNewerVersionsDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -1955554976528303894L;
        private final int numNewerVersions;

        public NumNewerVersionsDeleteRule(int numNewerVersions) {
            super(DeleteRule.Type.NUM_NEWER_VERSIONS);
            this.numNewerVersions = numNewerVersions;
        }

        public int getNumNewerVersions() {
            return this.numNewerVersions;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setNumNewerVersions(Integer.valueOf(this.numNewerVersions));
        }
    }

    public static class CreatedBeforeDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 881692650279195867L;
        private final long timeMillis;

        public CreatedBeforeDeleteRule(long timeMillis) {
            super(DeleteRule.Type.CREATE_BEFORE);
            this.timeMillis = timeMillis;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setCreatedBefore(new DateTime(this.timeMillis));
        }
    }

    static class RawDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = -7166938278642301933L;
        private transient Bucket.Lifecycle.Rule rule;

        RawDeleteRule(Bucket.Lifecycle.Rule rule) {
            super(DeleteRule.Type.UNKNOWN);
            this.rule = rule;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeUTF(this.rule.toString());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.rule = (Bucket.Lifecycle.Rule)new JacksonFactory().fromString(in.readUTF(), Bucket.Lifecycle.Rule.class);
        }

        @Override
        Bucket.Lifecycle.Rule toPb() {
            return this.rule;
        }
    }

    public static class AgeDeleteRule
    extends DeleteRule {
        private static final long serialVersionUID = 5697166940712116380L;
        private final int daysToLive;

        public AgeDeleteRule(int daysToLive) {
            super(DeleteRule.Type.AGE);
            this.daysToLive = daysToLive;
        }

        public int getDaysToLive() {
            return this.daysToLive;
        }

        @Override
        void populateCondition(Bucket.Lifecycle.Rule.Condition condition) {
            condition.setAge(Integer.valueOf(this.daysToLive));
        }
    }

    public static abstract class DeleteRule
    implements Serializable {
        private static final long serialVersionUID = 3137971668395933033L;
        private static final String SUPPORTED_ACTION = "Delete";
        private final Type type;

        DeleteRule(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DeleteRule other = (DeleteRule)obj;
            return Objects.equals(this.toPb(), other.toPb());
        }

        Bucket.Lifecycle.Rule toPb() {
            Bucket.Lifecycle.Rule rule = new Bucket.Lifecycle.Rule();
            rule.setAction(new Bucket.Lifecycle.Rule.Action().setType(SUPPORTED_ACTION));
            Bucket.Lifecycle.Rule.Condition condition = new Bucket.Lifecycle.Rule.Condition();
            this.populateCondition(condition);
            rule.setCondition(condition);
            return rule;
        }

        abstract void populateCondition(Bucket.Lifecycle.Rule.Condition var1);

        static DeleteRule fromPb(Bucket.Lifecycle.Rule rule) {
            if (rule.getAction() != null && SUPPORTED_ACTION.endsWith(rule.getAction().getType())) {
                Bucket.Lifecycle.Rule.Condition condition = rule.getCondition();
                Integer age = condition.getAge();
                if (age != null) {
                    return new AgeDeleteRule(age);
                }
                DateTime dateTime = condition.getCreatedBefore();
                if (dateTime != null) {
                    return new CreatedBeforeDeleteRule(dateTime.getValue());
                }
                Integer numNewerVersions = condition.getNumNewerVersions();
                if (numNewerVersions != null) {
                    return new NumNewerVersionsDeleteRule(numNewerVersions);
                }
                Boolean isLive = condition.getIsLive();
                if (isLive != null) {
                    return new IsLiveDeleteRule(isLive);
                }
            }
            return new RawDeleteRule(rule);
        }

        public static enum Type {
            AGE,
            CREATE_BEFORE,
            NUM_NEWER_VERSIONS,
            IS_LIVE,
            UNKNOWN;

        }
    }
}

