/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.stats.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MeasurementDescriptor {
    public static final int MAX_LENGTH = 255;
    private final String name;
    private final String description;
    private final MeasurementUnit unit;

    public static MeasurementDescriptor create(String string, String string2, MeasurementUnit measurementUnit) {
        return new MeasurementDescriptor(string, string2, measurementUnit);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public MeasurementUnit getUnit() {
        return this.unit;
    }

    private MeasurementDescriptor(String string, String string2, MeasurementUnit measurementUnit) {
        this.name = StringUtil.sanitize(string);
        this.description = string2;
        this.unit = measurementUnit;
    }

    public static final class MeasurementUnit {
        private final int power10;
        private final List<BasicUnit> numerators;
        private final List<BasicUnit> denominators;

        public static MeasurementUnit create(int n, List<BasicUnit> list, List<BasicUnit> list2) {
            return new MeasurementUnit(n, list, list2);
        }

        public static MeasurementUnit create(int n, List<BasicUnit> list) {
            return new MeasurementUnit(n, list, new ArrayList<BasicUnit>());
        }

        public int getPower10() {
            return this.power10;
        }

        public List<BasicUnit> getNumerators() {
            return this.numerators;
        }

        public final List<BasicUnit> getDenominators() {
            return this.denominators;
        }

        private MeasurementUnit(int n, List<BasicUnit> list, List<BasicUnit> list2) {
            this.power10 = n;
            this.numerators = Collections.unmodifiableList(new ArrayList<BasicUnit>(list));
            this.denominators = Collections.unmodifiableList(new ArrayList<BasicUnit>(list2));
        }
    }

    public static enum BasicUnit {
        SCALAR,
        BITS,
        BYTES,
        SECONDS,
        CORES;

    }
}

