/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;

public interface ArchiveActionFacade {
    public FileTree zipTree(Object var1);

    public FileTree tarTree(Object var1);

    public static abstract class ServiceBased
    implements ArchiveActionFacade {
        @Inject
        public abstract ArchiveOperations getArchiveOperations();

        @Override
        public FileTree zipTree(Object path) {
            return this.getArchiveOperations().zipTree(path);
        }

        @Override
        public FileTree tarTree(Object path) {
            return this.getArchiveOperations().tarTree(path);
        }
    }

    public static abstract class InternalServiceBased
    implements ArchiveActionFacade {
        @Inject
        public abstract FileOperations getFileOperations();

        @Override
        public FileTree zipTree(Object path) {
            return this.getFileOperations().zipTree(path);
        }

        @Override
        public FileTree tarTree(Object path) {
            return this.getFileOperations().tarTree(path);
        }
    }

    public static class ProjectBased
    implements ArchiveActionFacade {
        private final Project project;

        ProjectBased(Project project) {
            this.project = project;
        }

        @Override
        public FileTree zipTree(Object path) {
            return this.project.zipTree(path);
        }

        @Override
        public FileTree tarTree(Object path) {
            return this.project.tarTree(path);
        }
    }
}

