/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.internal.transport.http;

import gradlegitproperties.org.eclipse.jgit.internal.transport.http.NetscapeCookieFile;
import gradlegitproperties.org.eclipse.jgit.transport.HttpConfig;
import gradlegitproperties.org.eclipse.jgit.util.LRUMap;
import java.nio.file.Path;

public class NetscapeCookieFileCache {
    private final LRUMap<Path, NetscapeCookieFile> cookieFileMap;
    private static NetscapeCookieFileCache instance;

    private NetscapeCookieFileCache(HttpConfig config) {
        this.cookieFileMap = new LRUMap(config.getCookieFileCacheLimit(), config.getCookieFileCacheLimit());
    }

    public static NetscapeCookieFileCache getInstance(HttpConfig config) {
        if (instance == null) {
            return new NetscapeCookieFileCache(config);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NetscapeCookieFile getEntry(Path path) {
        if (this.cookieFileMap.containsKey(path)) return (NetscapeCookieFile)this.cookieFileMap.get(path);
        Class<NetscapeCookieFileCache> clazz = NetscapeCookieFileCache.class;
        synchronized (NetscapeCookieFileCache.class) {
            if (this.cookieFileMap.containsKey(path)) return (NetscapeCookieFile)this.cookieFileMap.get(path);
            this.cookieFileMap.put(path, new NetscapeCookieFile(path));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (NetscapeCookieFile)this.cookieFileMap.get(path);
        }
    }
}

