/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.service;

import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.service.ServiceEventBuilder;
import java.io.IOException;

public class ServiceEmitter
implements Emitter {
    private final String service;
    private final String host;
    private final Emitter emitter;

    public ServiceEmitter(String service, String host, Emitter emitter) {
        this.service = service;
        this.host = host;
        this.emitter = emitter;
    }

    public String getService() {
        return this.service;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    @LifecycleStart
    public void start() {
        this.emitter.start();
    }

    @Override
    public void emit(Event event) {
        this.emitter.emit(event);
    }

    public void emit(ServiceEventBuilder builder) {
        this.emit((Event)builder.build(this.service, this.host));
    }

    @Override
    public void flush() throws IOException {
        this.emitter.flush();
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.emitter.close();
    }
}

