/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.PathType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class SchemaLocation {
    private static final JsonNodePath JSON_POINTER = new JsonNodePath(PathType.JSON_POINTER);
    private static final JsonNodePath ANCHOR = new JsonNodePath(PathType.URI_REFERENCE);
    public static final SchemaLocation DOCUMENT = new SchemaLocation(null, JSON_POINTER);
    private final AbsoluteIri absoluteIri;
    private final JsonNodePath fragment;
    private volatile String value = null;

    public SchemaLocation(AbsoluteIri absoluteIri, JsonNodePath fragment) {
        this.absoluteIri = absoluteIri;
        this.fragment = fragment;
    }

    public SchemaLocation(AbsoluteIri absoluteIri) {
        this(absoluteIri, JSON_POINTER);
    }

    public AbsoluteIri getAbsoluteIri() {
        return this.absoluteIri;
    }

    public JsonNodePath getFragment() {
        return this.fragment;
    }

    public SchemaLocation append(String token) {
        return new SchemaLocation(this.absoluteIri, this.fragment.append(token));
    }

    public SchemaLocation append(int index) {
        return new SchemaLocation(this.absoluteIri, this.fragment.append(index));
    }

    public static SchemaLocation of(String iri) {
        if (iri == null) {
            return null;
        }
        if ("#".equals(iri)) {
            return DOCUMENT;
        }
        AbsoluteIri absoluteIri = null;
        JsonNodePath fragment = JSON_POINTER;
        int index = iri.indexOf(35);
        if (index == -1) {
            absoluteIri = AbsoluteIri.of(iri);
        } else {
            absoluteIri = AbsoluteIri.of(iri.substring(0, index));
            if (iri.length() > index + 1) {
                fragment = Fragment.of(iri.substring(index + 1));
            }
        }
        return new SchemaLocation(absoluteIri, fragment);
    }

    public SchemaLocation resolve(String absoluteIriReferenceOrFragment) {
        String part1;
        String part0;
        if (absoluteIriReferenceOrFragment == null) {
            return this;
        }
        if ("#".equals(absoluteIriReferenceOrFragment)) {
            return new SchemaLocation(this.getAbsoluteIri(), JSON_POINTER);
        }
        JsonNodePath fragment = JSON_POINTER;
        int index = absoluteIriReferenceOrFragment.indexOf(35);
        AbsoluteIri absoluteIri = this.getAbsoluteIri();
        String string = part0 = index == -1 ? absoluteIriReferenceOrFragment : absoluteIriReferenceOrFragment.substring(0, index);
        if (absoluteIri != null) {
            if (!part0.isEmpty()) {
                absoluteIri = absoluteIri.resolve(part0);
            }
        } else {
            absoluteIri = AbsoluteIri.of(part0);
        }
        if (index != -1 && absoluteIriReferenceOrFragment.length() > index + 1 && !(part1 = absoluteIriReferenceOrFragment.substring(index + 1)).isEmpty()) {
            fragment = Fragment.of(part1);
        }
        return new SchemaLocation(absoluteIri, fragment);
    }

    public static String resolve(SchemaLocation schemaLocation, String absoluteIriReferenceOrFragment) {
        String part0;
        if ("#".equals(absoluteIriReferenceOrFragment)) {
            return schemaLocation.getAbsoluteIri().toString() + "#";
        }
        int index = absoluteIriReferenceOrFragment.indexOf(35);
        AbsoluteIri absoluteIri = schemaLocation.getAbsoluteIri();
        String resolved = part0 = index == -1 ? absoluteIriReferenceOrFragment : absoluteIriReferenceOrFragment.substring(0, index);
        if (absoluteIri != null) {
            resolved = !part0.isEmpty() ? absoluteIri.resolve(part0).toString() : absoluteIri.toString();
        }
        String part1 = "";
        if (index != -1 && absoluteIriReferenceOrFragment.length() > index + 1) {
            part1 = absoluteIriReferenceOrFragment.substring(index + 1);
        }
        resolved = !part1.isEmpty() ? resolved + "#" + part1 : resolved + "#";
        return resolved;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        if (this.value == null) {
            if (this.absoluteIri != null && this.fragment == null) {
                this.value = this.absoluteIri.toString();
            } else {
                StringBuilder result = new StringBuilder();
                if (this.absoluteIri != null) {
                    result.append(this.absoluteIri.toString());
                }
                result.append("#");
                if (this.fragment != null) {
                    result.append(this.fragment.toString());
                }
                this.value = result.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.fragment, this.absoluteIri);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaLocation other = (SchemaLocation)obj;
        return Objects.equals(this.fragment, other.fragment) && Objects.equals(this.absoluteIri, other.absoluteIri);
    }

    public static class Builder {
        private AbsoluteIri absoluteIri;
        private JsonNodePath fragment = SchemaLocation.access$000();

        protected Builder absoluteIri(AbsoluteIri absoluteIri) {
            this.absoluteIri = absoluteIri;
            return this;
        }

        protected Builder absoluteIri(String absoluteIri) {
            return this.absoluteIri(AbsoluteIri.of(absoluteIri));
        }

        protected Builder fragment(JsonNodePath fragment) {
            this.fragment = fragment;
            return this;
        }

        protected Builder fragment(String fragment) {
            return this.fragment(Fragment.of(fragment));
        }

        public SchemaLocation build() {
            return new SchemaLocation(this.absoluteIri, this.fragment);
        }
    }

    public static class Fragment {
        public static JsonNodePath of(String fragmentString) {
            if (fragmentString.startsWith("#")) {
                fragmentString = fragmentString.substring(1);
            }
            JsonNodePath fragment = JSON_POINTER;
            String[] fragmentParts = fragmentString.split("/");
            boolean jsonPointer = false;
            if (fragmentString.startsWith("/")) {
                jsonPointer = true;
            } else {
                fragment = ANCHOR;
            }
            int index = -1;
            for (int fragmentPartIndex = 0; fragmentPartIndex < fragmentParts.length; ++fragmentPartIndex) {
                if (fragmentPartIndex == 0 && jsonPointer) continue;
                String fragmentPart = fragmentParts[fragmentPartIndex];
                for (int x = 0; x < fragmentPart.length(); ++x) {
                    char ch = fragmentPart.charAt(x);
                    if (ch >= '0' && ch <= '9') {
                        index = x == 0 ? 0 : (index *= 10);
                        index += ch - 48;
                        continue;
                    }
                    index = -1;
                    break;
                }
                if (index != -1) {
                    fragment = fragment.append(index);
                    continue;
                }
                String fragmentPartString = fragmentPart.toString();
                if (PathType.JSON_POINTER.equals((Object)fragment.getPathType())) {
                    if (fragmentPartString.contains("~")) {
                        fragmentPartString = fragmentPartString.replace("~1", "/");
                        fragmentPartString = fragmentPartString.replace("~0", "~");
                    }
                    if (fragmentPartString.contains("%")) {
                        try {
                            fragmentPartString = URLDecoder.decode(fragmentPartString, StandardCharsets.UTF_8.toString());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
                fragment = fragment.append(fragmentPartString);
            }
            if (index == -1 && fragmentString.endsWith("/")) {
                fragment = fragment.append("");
            }
            return fragment;
        }

        public static boolean isFragment(String fragmentString) {
            return fragmentString.startsWith("#");
        }

        public static boolean isJsonPointerFragment(String fragmentString) {
            return fragmentString.startsWith("#/");
        }

        public static boolean isAnchorFragment(String fragmentString) {
            return Fragment.isFragment(fragmentString) && !Fragment.isDocumentFragment(fragmentString) && !Fragment.isJsonPointerFragment(fragmentString);
        }

        public static boolean isDocumentFragment(String fragmentString) {
            return "#".equals(fragmentString);
        }
    }
}

