/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge;

import com.newrelic.agent.bridge.CollectionFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DefaultCollectionFactory
implements CollectionFactory {
    @Override
    public <K, V> Map<K, V> createConcurrentWeakKeyedMap() {
        return Collections.synchronizedMap(new WeakHashMap());
    }

    @Override
    public <K, V> Map<K, V> createConcurrentTimeBasedEvictionMap(long ageInSeconds) {
        return Collections.synchronizedMap(new HashMap());
    }

    @Override
    public <K, V> Function<K, V> memorize(Function<K, V> loader, int maxSize) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return k -> {
            if (map.size() >= maxSize) {
                Object value = map.get(k);
                return value == null ? loader.apply(k) : value;
            }
            return map.computeIfAbsent(k, loader);
        };
    }

    @Override
    public <K, V> Function<K, V> createAccessTimeBasedCache(long ageInSeconds, int initialCapacity, Function<K, V> loader) {
        return loader;
    }
}

