/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge;

public enum TransactionNamePriority {
    NONE(0, 0),
    REQUEST_URI(1, 4),
    STATUS_CODE(2, 5),
    FILTER_NAME(3, 1),
    FILTER_INIT_PARAM(4, 6),
    SERVLET_NAME(5, 2),
    SERVLET_INIT_PARAM(6, 7),
    JSP(7, 3),
    FRAMEWORK_LOW(8, 8),
    FRAMEWORK(9, 9),
    FRAMEWORK_HIGH(10, 10),
    CUSTOM_LOW(11, 11),
    CUSTOM_HIGH(12, 12),
    FROZEN(13, 13);

    public final int legacyPriority;
    public final int pathPriority;

    private TransactionNamePriority(int legacyPriority, int pathPriority) {
        this.legacyPriority = legacyPriority;
        this.pathPriority = pathPriority;
    }

    public static TransactionNamePriority convert(com.newrelic.api.agent.TransactionNamePriority priority) {
        switch (priority) {
            case CUSTOM_HIGH: {
                return CUSTOM_HIGH;
            }
            case CUSTOM_LOW: {
                return CUSTOM_LOW;
            }
            case FRAMEWORK_HIGH: {
                return FRAMEWORK_HIGH;
            }
            case FRAMEWORK_LOW: {
                return FRAMEWORK_LOW;
            }
            case REQUEST_URI: {
                return REQUEST_URI;
            }
        }
        throw new IllegalArgumentException("Unmapped TransactionNamePriority " + priority);
    }
}

