/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge.datastore;

import com.newrelic.agent.bridge.AgentBridge;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.logging.Level;

public final class DatastoreInstanceDetection {
    private static ThreadLocal<ConnectionState> state = new ThreadLocal<ConnectionState>(){

        @Override
        protected ConnectionState initialValue() {
            return ConnectionState.DO_NOT_DETECT_ADDRESS;
        }
    };
    private static final ThreadLocal<InetSocketAddress> address = new ThreadLocal();
    private static final Map<Object, InetSocketAddress> connectionToAddress = AgentBridge.collectionFactory.createConcurrentWeakKeyedMap();

    private DatastoreInstanceDetection() {
    }

    public static boolean shouldDetectConnectionAddress() {
        return ConnectionState.DETECT_ADDRESS.equals((Object)state.get());
    }

    public static void stopDetectingConnectionAddress() {
        state.set(ConnectionState.DO_NOT_DETECT_ADDRESS);
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Not detecting connection address");
        DatastoreInstanceDetection.clearAddress();
    }

    public static void detectConnectionAddress() {
        state.set(ConnectionState.DETECT_ADDRESS);
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Detecting connection address");
    }

    public static void associateAddress(Object connection) {
        DatastoreInstanceDetection.associateAddress(connection, DatastoreInstanceDetection.getCurrentAddress());
    }

    public static void associateAddress(Object connection, InetSocketAddress addressToStore) {
        if (ConnectionState.DO_NOT_DETECT_ADDRESS.equals((Object)state.get())) {
            return;
        }
        if (connection != null && addressToStore != null) {
            connectionToAddress.put(connection, addressToStore);
            AgentBridge.getAgent().getLogger().log(Level.FINEST, "Added connection: {0} for address: {1}", connection, (Object)addressToStore);
        } else {
            AgentBridge.getAgent().getLogger().log(Level.FINEST, "Unable to add address: {0} for connection: {1}", (Object)addressToStore, connection);
        }
    }

    public static void saveAddress(InetSocketAddress addressToStore) {
        if (addressToStore == null || ConnectionState.DO_NOT_DETECT_ADDRESS.equals((Object)state.get())) {
            return;
        }
        InetSocketAddress previousAddress = address.get();
        if (previousAddress != null && !previousAddress.equals(addressToStore)) {
            AgentBridge.getAgent().getLogger().log(Level.FINEST, "Two different addresses detected: {0} and {1}. Invalidating previously detected address.", (Object)previousAddress, address);
            DatastoreInstanceDetection.stopDetectingConnectionAddress();
            return;
        }
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Storing address: {0}", address);
        address.set(addressToStore);
    }

    public static void clearAddress() {
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Clearing last detected address");
        address.set(null);
    }

    public static InetSocketAddress getCurrentAddress() {
        return address.get();
    }

    public static InetSocketAddress getAddressForConnection(Object connection) {
        if (connection == null) {
            return null;
        }
        InetSocketAddress address = connectionToAddress.get(connection);
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Address for connection: {0} is: {1}", connection, (Object)address);
        return address;
    }

    private static enum ConnectionState {
        DO_NOT_DETECT_ADDRESS,
        DETECT_ADDRESS;

    }
}

