/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge.external;

import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.Transaction;
import com.newrelic.agent.bridge.external.URISupport;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;

public class ExternalMetrics {
    public static final String METRIC_NAMESPACE = "External";
    public static final String METRIC_NAME = "External/{0}/{1}";
    public static final String TRANSACTION_SEGMENT_NAME = "External/{0}/{1}/{2}";
    public static final String ALL = "External/all";
    public static final String ALL_WEB = "External/allWeb";
    public static final String ALL_OTHER = "External/allOther";
    public static final String ALL_HOST = "External/{0}/all";
    public static final String UNKNOWN_HOST = "UnknownHost";

    private static String fixOperations(String ... operations) {
        StringBuilder builder = new StringBuilder();
        for (String operation : operations) {
            if (operation == null) {
                return null;
            }
            if (operation.startsWith("/")) {
                builder.append(operation);
                continue;
            }
            builder.append('/').append(operation);
        }
        return builder.substring(1);
    }

    public static void makeExternalComponentMetric(TracedMethod method, String host, String library, boolean includeOperationInMetric, String uri, String ... operations) {
        if (operations == null || operations.length == 0) {
            String metricName = MessageFormat.format(METRIC_NAME, host, library);
            method.setMetricNameFormatInfo(metricName, metricName, uri);
        } else {
            String operationsPath = ExternalMetrics.fixOperations(operations);
            String transactionSegmentName = MessageFormat.format(TRANSACTION_SEGMENT_NAME, host, library, operationsPath);
            String metricName = includeOperationInMetric ? transactionSegmentName : MessageFormat.format(METRIC_NAME, host, library);
            method.setMetricNameFormatInfo(metricName, transactionSegmentName, uri);
        }
    }

    public static void makeExternalComponentTrace(Transaction transaction, TracedMethod method, String host, String library, boolean includeOperationInMetric, String uri, String ... operations) {
        ExternalMetrics.makeExternalComponentTrace(transaction.isWebTransaction(), method, host, library, includeOperationInMetric, uri, operations);
    }

    public static void makeExternalComponentTrace(boolean isWebTransaction, TracedMethod method, String host, String library, boolean includeOperationInMetric, String uri, String ... operations) {
        String hostName = host == null ? UNKNOWN_HOST : host;
        ExternalMetrics.makeExternalComponentMetric(method, hostName, library, includeOperationInMetric, uri, operations);
        if (UNKNOWN_HOST.equals(hostName)) {
            return;
        }
        method.addExclusiveRollupMetricName(ALL);
        if (isWebTransaction) {
            method.addExclusiveRollupMetricName(ALL_WEB);
        } else {
            method.addExclusiveRollupMetricName(ALL_OTHER);
        }
        method.addExclusiveRollupMetricName(MessageFormat.format(ALL_HOST, hostName));
    }

    @Deprecated
    public static String getURI(URI url) {
        return URISupport.getURI(url);
    }

    @Deprecated
    public static String getURI(URL url) {
        return URISupport.getURI(url);
    }

    @Deprecated
    public static String getURI(String scheme, String host, int port, String path) {
        return URISupport.getURI(scheme, host, port, path);
    }
}

