/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge;

import com.newrelic.agent.bridge.Agent;
import com.newrelic.agent.bridge.AsyncApi;
import com.newrelic.agent.bridge.CloudApi;
import com.newrelic.agent.bridge.CollectionFactory;
import com.newrelic.agent.bridge.DefaultCollectionFactory;
import com.newrelic.agent.bridge.ExtensionHolderFactory;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.bridge.JmxApi;
import com.newrelic.agent.bridge.NoOpAgent;
import com.newrelic.agent.bridge.NoOpAsyncApi;
import com.newrelic.agent.bridge.NoOpCloud;
import com.newrelic.agent.bridge.NoOpInstrumentation;
import com.newrelic.agent.bridge.NoOpJmxApi;
import com.newrelic.agent.bridge.NoOpPrivateApi;
import com.newrelic.agent.bridge.NoOpPublicApi;
import com.newrelic.agent.bridge.NoOpToken;
import com.newrelic.agent.bridge.PrivateApi;
import com.newrelic.agent.bridge.PublicApi;
import com.newrelic.agent.bridge.Token;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.Transaction;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.api.agent.weaver.internal.WeavePackageType;
import java.lang.reflect.InvocationHandler;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class AgentBridge {
    public static final Class<?>[] API_CLASSES = new Class[]{PrivateApi.class, TracedMethod.class, Instrumentation.class, AsyncApi.class, Transaction.class, JmxApi.class, MetricAggregator.class};
    public static volatile PublicApi publicApi = new NoOpPublicApi();
    public static volatile PrivateApi privateApi = new NoOpPrivateApi();
    public static volatile JmxApi jmxApi = new NoOpJmxApi();
    public static volatile Instrumentation instrumentation = new NoOpInstrumentation();
    public static volatile AsyncApi asyncApi = new NoOpAsyncApi();
    public static volatile CloudApi cloud = NoOpCloud.INSTANCE;
    public static volatile CollectionFactory collectionFactory = new DefaultCollectionFactory();
    public static volatile InvocationHandler agentHandler;
    public static volatile Agent agent;
    public static volatile ExtensionHolderFactory extensionHolderFactory;
    public static volatile ThreadLocal<WeavePackageType> currentApiSource;
    public static ThreadLocal<TokenAndRefCount> activeToken;

    public static Agent getAgent() {
        return agent;
    }

    static {
        agent = NoOpAgent.INSTANCE;
        extensionHolderFactory = new ExtensionHolderFactory.NoOpExtensionHolderFactory();
        currentApiSource = new ThreadLocal<WeavePackageType>(){

            @Override
            protected WeavePackageType initialValue() {
                return null;
            }

            @Override
            public WeavePackageType get() {
                try {
                    WeavePackageType weavePackageType = (WeavePackageType)((Object)super.get());
                    if (weavePackageType == null) {
                        return WeavePackageType.UNKNOWN;
                    }
                    return weavePackageType;
                }
                catch (Throwable t) {
                    return WeavePackageType.UNKNOWN;
                }
            }

            @Override
            public void set(WeavePackageType value) {
                try {
                    super.set(value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void remove() {
                try {
                    super.remove();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        activeToken = new ThreadLocal<TokenAndRefCount>(){};
    }

    public static class TokenAndRefCount {
        public Token token;
        public AtomicReference<Object> tracedMethod;
        public AtomicInteger refCount;

        public TokenAndRefCount(Token token, TracedMethod tracedMethod, AtomicInteger refCount) {
            this.token = token == null ? NoOpToken.INSTANCE : token;
            this.tracedMethod = new AtomicReference<TracedMethod>(tracedMethod);
            this.refCount = refCount;
        }
    }
}

