/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge.aimonitoring;

import com.newrelic.api.agent.Config;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;

public class AiMonitoringUtils {
    private static final boolean AI_MONITORING_ENABLED_DEFAULT = false;
    private static final boolean AI_MONITORING_STREAMING_ENABLED_DEFAULT = true;
    private static final boolean AI_MONITORING_RECORD_CONTENT_ENABLED_DEFAULT = true;
    private static final boolean HIGH_SECURITY_ENABLED_DEFAULT = false;
    public static final String COLLECT_AI = "collect_ai";

    public static boolean isAiMonitoringEnabled() {
        Config config = NewRelic.getAgent().getConfig();
        Boolean collectAi = (Boolean)config.getValue(COLLECT_AI);
        Boolean aimEnabled = (Boolean)config.getValue("ai_monitoring.enabled", (Object)false);
        Boolean highSecurity = (Boolean)config.getValue("high_security", (Object)false);
        if (collectAi != null && !collectAi.booleanValue()) {
            NewRelic.getAgent().getLogger().log(Level.FINE, "AIM: AI Monitoring is disabled due to account wide server side config.");
            NewRelic.incrementCounter("Supportability/Java/ML/Disabled");
            return false;
        }
        if (highSecurity.booleanValue() || !aimEnabled.booleanValue()) {
            aimEnabled = false;
            String disabledReason = highSecurity != false ? "High Security Mode." : "agent config.";
            NewRelic.getAgent().getLogger().log(Level.FINE, "AIM: AI Monitoring is disabled due to " + disabledReason);
            NewRelic.incrementCounter("Supportability/Java/ML/Disabled");
        } else {
            NewRelic.incrementCounter("Supportability/Java/ML/Enabled");
        }
        return aimEnabled;
    }

    public static boolean isAiMonitoringStreamingEnabled() {
        Boolean enabled = (Boolean)NewRelic.getAgent().getConfig().getValue("ai_monitoring.streaming.enabled", (Object)true);
        if (enabled.booleanValue()) {
            NewRelic.incrementCounter("Supportability/Java/ML/Streaming/Enabled");
        } else {
            NewRelic.incrementCounter("Supportability/Java/ML/Streaming/Disabled");
        }
        return enabled;
    }

    public static boolean isAiMonitoringRecordContentEnabled() {
        Boolean enabled = (Boolean)NewRelic.getAgent().getConfig().getValue("ai_monitoring.record_content.enabled", (Object)true);
        if (enabled.booleanValue()) {
            NewRelic.incrementCounter("Supportability/Java/ML/RecordContent/Enabled");
        } else {
            NewRelic.incrementCounter("Supportability/Java/ML/RecordContent/Disabled");
        }
        return enabled;
    }
}

