/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge.external;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URISupport {
    public static String getURI(URI theUri) {
        if (theUri == null) {
            return "";
        }
        return URISupport.getURI(theUri.getScheme(), theUri.getHost(), theUri.getPort(), theUri.getPath());
    }

    public static String getURI(URL theUrl) {
        if (theUrl == null) {
            return "";
        }
        try {
            return URISupport.getURI(theUrl.toURI());
        }
        catch (URISyntaxException e) {
            return URISupport.getURI(theUrl.getProtocol(), theUrl.getHost(), theUrl.getPort(), theUrl.getPath());
        }
    }

    public static String getURI(String scheme, String host, int port, String path) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme);
            sb.append("://");
        }
        if (host != null) {
            sb.append(host);
            if (port >= 0) {
                sb.append(":");
                sb.append(port);
            }
        }
        if (path != null) {
            sb.append(path);
        }
        return sb.toString();
    }
}

