/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

public final class TracerFlags {
    public static final int GENERATE_SCOPED_METRIC = 2;
    public static final int TRANSACTION_TRACER_SEGMENT = 4;
    public static final int DISPATCHER = 8;
    public static final int CUSTOM = 16;
    public static final int LEAF = 32;
    public static final int ASYNC = 64;

    private TracerFlags() {
    }

    public static boolean isRoot(int flags) {
        return TracerFlags.isDispatcher(flags) || TracerFlags.isAsync(flags);
    }

    public static int forceMandatoryRootFlags(int flags) {
        return flags | 4 | 2;
    }

    public static boolean isAsync(int flags) {
        return (flags & 0x40) == 64;
    }

    public static int clearAsync(int flags) {
        return flags & 0xFFFFFFBF;
    }

    public static boolean isDispatcher(int flags) {
        return (flags & 8) == 8;
    }

    public static int clearSegment(int flags) {
        return flags & 0xFFFFFFFB;
    }

    public static boolean isCustom(int flags) {
        return (flags & 0x10) == 16;
    }

    public static int getDispatcherFlags(boolean dispatcher) {
        return dispatcher ? 8 : 0;
    }
}

