/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.weaver.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum WeavePackageType {
    INTERNAL("/Internal"),
    FIELD("/Field"),
    CUSTOM("/Custom"),
    UNKNOWN("/API");

    private static final String SUPPORTABILITY_API = "Supportability/API/";
    private final String supportabilityPostfix;
    private final ConcurrentMap<String, String> supportabilityCache;

    private WeavePackageType(String supportabilityPostfix) {
        this.supportabilityPostfix = supportabilityPostfix;
        this.supportabilityCache = new ConcurrentHashMap<String, String>();
    }

    public String getSupportabilityMetric(String supportabilityPrefix) {
        String result = (String)this.supportabilityCache.get(supportabilityPrefix);
        if (result == null) {
            result = SUPPORTABILITY_API + supportabilityPrefix + this.supportabilityPostfix;
            this.supportabilityCache.putIfAbsent(supportabilityPrefix, result);
        }
        return result;
    }

    public boolean isInternal() {
        boolean isInternal;
        switch (this) {
            case INTERNAL: {
                isInternal = true;
                break;
            }
            default: {
                isInternal = false;
            }
        }
        return isInternal;
    }
}

