/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge;

import com.newrelic.agent.bridge.AgentBridge;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;

public class ManifestUtils {
    public static String getVersionFromManifest(Class<?> clazz, String jarName, String defaultVersion) {
        return ManifestUtils.getVersionFromManifest(clazz, jarName, defaultVersion, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getVersionFromManifest(Class<?> clazz, String jarName, String defaultVersion, boolean forceFallback) {
        String version = null;
        try {
            if (forceFallback) {
                throw new RuntimeException("Forced exception");
            }
            URL jarForClass = clazz.getProtectionDomain().getCodeSource().getLocation();
            JarFile jarFile = new JarFile(jarForClass.getPath());
            version = ManifestUtils.getVersionFromManifest(jarFile.getManifest());
            return version == null ? defaultVersion : version;
        }
        catch (Exception e) {
            try {
                Enumeration<URL> manifests = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (manifests.hasMoreElements()) {
                    URL url = manifests.nextElement();
                    if (!url.getFile().contains(jarName)) continue;
                    InputStream manifestStream = url.openStream();
                    Throwable throwable = null;
                    try {
                        Manifest manifest = new Manifest(manifestStream);
                        version = ManifestUtils.getVersionFromManifest(manifest);
                        return version == null ? defaultVersion : version;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (manifestStream != null) {
                            if (throwable != null) {
                                try {
                                    manifestStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                manifestStream.close();
                            }
                        }
                        return version == null ? defaultVersion : version;
                    }
                }
            }
            catch (Exception e2) {
                AgentBridge.getAgent().getLogger().log(Level.FINE, "Unable to determine version from manifest: " + e.toString());
            }
        }
        return version == null ? defaultVersion : version;
    }

    public static String getVersionFromManifest(Manifest manifest) {
        String version = ManifestUtils.getVersion(manifest.getMainAttributes());
        if (version == null && !manifest.getEntries().isEmpty()) {
            version = ManifestUtils.getVersion(manifest.getEntries().values().iterator().next());
        }
        return version;
    }

    private static String getVersion(Attributes attributes) {
        String version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            version = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            if (version == null) {
                version = attributes.getValue("Bundle-Version");
            }
            if (version == null) {
                version = attributes.getValue("Driver-Version");
            }
        }
        return version;
    }
}

