/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge.logging;

import com.newrelic.agent.bridge.logging.LogAttributeKey;
import com.newrelic.agent.bridge.logging.LogAttributeType;
import com.newrelic.api.agent.NewRelic;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;

public class AppLoggingUtils {
    public static final int DEFAULT_NUM_OF_LOG_EVENT_ATTRIBUTES = 11;
    public static final LogAttributeKey INSTRUMENTATION = new LogAttributeKey("instrumentation", LogAttributeType.AGENT);
    public static final LogAttributeKey MESSAGE = new LogAttributeKey("message", LogAttributeType.AGENT);
    public static final LogAttributeKey TIMESTAMP = new LogAttributeKey("timestamp", LogAttributeType.AGENT);
    public static final LogAttributeKey LEVEL = new LogAttributeKey("level", LogAttributeType.AGENT);
    public static final LogAttributeKey ERROR_MESSAGE = new LogAttributeKey("error.message", LogAttributeType.AGENT);
    public static final LogAttributeKey ERROR_CLASS = new LogAttributeKey("error.class", LogAttributeType.AGENT);
    public static final LogAttributeKey ERROR_STACK = new LogAttributeKey("error.stack", LogAttributeType.AGENT);
    public static final LogAttributeKey THREAD_NAME = new LogAttributeKey("thread.name", LogAttributeType.AGENT);
    public static final LogAttributeKey THREAD_ID = new LogAttributeKey("thread.id", LogAttributeType.AGENT);
    public static final LogAttributeKey LOGGER_NAME = new LogAttributeKey("logger.name", LogAttributeType.AGENT);
    public static final LogAttributeKey LOGGER_FQCN = new LogAttributeKey("logger.fqcn", LogAttributeType.AGENT);
    public static final String UNKNOWN = "UNKNOWN";
    public static final String BLOB_PREFIX = "NR-LINKING";
    public static final String BLOB_DELIMITER = "|";
    public static final String TRACE_ID = "trace.id";
    public static final String HOSTNAME = "hostname";
    public static final String ENTITY_GUID = "entity.guid";
    public static final String ENTITY_NAME = "entity.name";
    public static final String SPAN_ID = "span.id";
    public static final String CONTEXT_DATA_ATTRIBUTE_PREFIX = "context.";
    private static final boolean APP_LOGGING_DEFAULT_ENABLED = true;
    private static final boolean APP_LOGGING_METRICS_DEFAULT_ENABLED = true;
    private static final boolean APP_LOGGING_FORWARDING_DEFAULT_ENABLED = true;
    private static final boolean APP_LOGGING_LOCAL_DECORATING_DEFAULT_ENABLED = false;
    private static final boolean APP_LOGGING_FORWARDING_INCLUDE_CONTEXT_DATA_DEFAULT_ENABLED = false;

    public static String getLinkingMetadataBlob() {
        return AppLoggingUtils.constructLinkingMetadataBlob(NewRelic.getAgent().getLinkingMetadata());
    }

    public static String getLinkingMetadataBlobFromMap(Map<String, String> agentLinkingMetadata) {
        return AppLoggingUtils.constructLinkingMetadataBlob(agentLinkingMetadata);
    }

    private static String constructLinkingMetadataBlob(Map<String, String> agentLinkingMetadata) {
        StringBuilder blob = new StringBuilder();
        blob.append(" ").append(BLOB_PREFIX).append(BLOB_DELIMITER);
        if (agentLinkingMetadata != null && !agentLinkingMetadata.isEmpty()) {
            AppLoggingUtils.appendAttributeToBlob(agentLinkingMetadata.get(ENTITY_GUID), blob);
            AppLoggingUtils.appendAttributeToBlob(agentLinkingMetadata.get(HOSTNAME), blob);
            AppLoggingUtils.appendAttributeToBlob(agentLinkingMetadata.get(TRACE_ID), blob);
            AppLoggingUtils.appendAttributeToBlob(agentLinkingMetadata.get(SPAN_ID), blob);
            AppLoggingUtils.appendAttributeToBlob(AppLoggingUtils.urlEncode(agentLinkingMetadata.get(ENTITY_NAME)), blob);
        }
        return blob.toString();
    }

    private static void appendAttributeToBlob(String attribute, StringBuilder blob) {
        if (attribute != null && !attribute.isEmpty()) {
            blob.append(attribute);
        }
        blob.append(BLOB_DELIMITER);
    }

    public static String urlEncode(String value) {
        try {
            if (value != null) {
                value = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
            }
        }
        catch (UnsupportedEncodingException e) {
            NewRelic.getAgent().getLogger().log(Level.WARNING, "Unable to URL encode entity.name for application_logging.local_decorating", (Object)e);
        }
        return value;
    }

    public static boolean isApplicationLoggingEnabled() {
        return (Boolean)NewRelic.getAgent().getConfig().getValue("application_logging.enabled", (Object)true);
    }

    public static boolean isApplicationLoggingMetricsEnabled() {
        return (Boolean)NewRelic.getAgent().getConfig().getValue("application_logging.metrics.enabled", (Object)true);
    }

    public static boolean isApplicationLoggingForwardingEnabled() {
        return (Boolean)NewRelic.getAgent().getConfig().getValue("application_logging.forwarding.enabled", (Object)true);
    }

    public static boolean isApplicationLoggingLocalDecoratingEnabled() {
        return (Boolean)NewRelic.getAgent().getConfig().getValue("application_logging.local_decorating.enabled", (Object)false);
    }

    public static boolean isAppLoggingContextDataEnabled() {
        return (Boolean)NewRelic.getAgent().getConfig().getValue("application_logging.forwarding.context_data.enabled", (Object)false);
    }
}

