/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.bridge.logging;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.api.agent.weaver.NewField;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Level;

public class Log4jUtils {
    private static final Map<Object, Object> linkingMetadataReflectFieldCache = AgentBridge.collectionFactory.createConcurrentWeakKeyedMap();

    public static Map<String, String> getLinkingMetadata(Object logEvent) {
        Field[] fieldList;
        if (logEvent == null) {
            return null;
        }
        Class<?> c = logEvent.getClass();
        Field cachedField = Log4jUtils.getFieldFromCache(c);
        if (cachedField != null) {
            return Log4jUtils.getLinkingMetadata(logEvent, cachedField);
        }
        for (Field field : fieldList = c.getFields()) {
            Map<String, String> metadata;
            if (((NewField[])field.getAnnotationsByType(NewField.class)).length == 0 || !field.getName().equals("agentLinkingMetadata") || (metadata = Log4jUtils.getLinkingMetadata(logEvent, field)) == null) continue;
            linkingMetadataReflectFieldCache.put(c, field);
            return metadata;
        }
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "No linking metadata found from log4j's LogEvent instance {0}", logEvent);
        return null;
    }

    private static Field getFieldFromCache(Class<?> c) {
        try {
            Object v = linkingMetadataReflectFieldCache.get(c);
            if (v != null) {
                return (Field)v;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private static Map<String, String> getLinkingMetadata(Object logEvent, Field field) {
        try {
            return (Map)field.get(logEvent);
        }
        catch (ClassCastException | IllegalAccessException e) {
            AgentBridge.getAgent().getLogger().log(Level.FINEST, "Exception from getting linking metadata from log4j's LogEvent instance {0}", logEvent, (Object)e);
            return null;
        }
    }
}

