/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic;

import com.newrelic.agent.deps.io.grpc.CallOptions;
import com.newrelic.agent.deps.io.grpc.Channel;
import com.newrelic.agent.deps.io.grpc.ClientCall;
import com.newrelic.agent.deps.io.grpc.ClientInterceptor;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCall;
import com.newrelic.agent.deps.io.grpc.ForwardingClientCallListener;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.MethodDescriptor;
import java.util.Map;

class HeadersInterceptor
implements ClientInterceptor {
    private final Map<String, String> headers;

    HeadersInterceptor(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new HeadersClientCall(method, callOptions, next);
    }

    private class HeadersClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private HeadersClientCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            super(next.newCall(method, callOptions));
        }

        @Override
        public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
            for (Map.Entry header : HeadersInterceptor.this.headers.entrySet()) {
                metadata.put(Metadata.Key.of(((String)header.getKey()).toLowerCase(), Metadata.ASCII_STRING_MARSHALLER), header.getValue());
            }
            super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                @Override
                public void onHeaders(Metadata headers) {
                    super.onHeaders(headers);
                }
            }, metadata);
        }
    }
}

