/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.attributes.AttributesFilter;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AttributesService
extends AbstractService
implements AgentConfigListener {
    private final boolean enabled;
    private final String defaultAppName;
    private volatile AttributesFilter defaultFilter;
    private final Map<String, AttributesFilter> appNamesToFilters;
    private final Map<String, Object> requestUriDummyMap = ImmutableMap.of("request.uri", "");

    public AttributesService() {
        super(AttributesService.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.enabled = config.getAttributesConfig().isEnabledRoot();
        this.defaultAppName = config.getApplicationName();
        this.defaultFilter = new AttributesFilter(config);
        this.appNamesToFilters = new ConcurrentHashMap<String, AttributesFilter>();
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getConfigService().removeIAgentConfigListener(this);
    }

    public boolean captureRequestParams(String appName) {
        return this.getFilter(appName).captureRequestParams();
    }

    public boolean captureMessageParams(String appName) {
        return this.getFilter(appName).captureMessageParams();
    }

    public boolean isAttributesEnabledForErrorEvents(String appName) {
        return this.getFilter(appName).isAttributesEnabledForErrorEvents();
    }

    public boolean isAttributesEnabledForTransactionEvents(String appName) {
        return this.getFilter(appName).isAttributesEnabledForTransactionEvents();
    }

    public boolean isAttributesEnabledForTransactionTraces(String appName) {
        return this.getFilter(appName).isAttributesEnabledForTransactionTraces();
    }

    public boolean isAttributesEnabledForBrowser(String appName) {
        return this.getFilter(appName).isAttributesEnabledForBrowser();
    }

    public boolean isAttributesEnabledForSpanEvents(String appName) {
        return this.getFilter(appName).isAttributesEnabledForSpanEvents();
    }

    public boolean isAttributesEnabledForTransactionSegments(String appName) {
        return this.getFilter(appName).isAttributesEnabledForTransactionSegments();
    }

    public Map<String, ?> filterAttributes(String appName, Map<String, Object> values2) {
        return this.getFilter(appName).filterAttributes(values2);
    }

    public Map<String, ?> filterErrorEventAttributes(String appName, Map<String, ?> values2) {
        return this.getFilter(appName).filterErrorEventAttributes(values2);
    }

    public Map<String, ?> filterTransactionEventAttributes(String appName, Map<String, ?> values2) {
        return this.getFilter(appName).filterTransactionEventAttributes(values2);
    }

    public Map<String, ?> filterTransactionTraceAttributes(String appName, Map<String, Object> values2) {
        return this.getFilter(appName).filterTransactionTraceAttributes(values2);
    }

    public Map<String, ?> filterBrowserAttributes(String appName, Map<String, Object> values2) {
        return this.getFilter(appName).filterBrowserAttributes(values2);
    }

    public Map<String, ?> filterSpanEventAttributes(String appName, Map<String, ?> values2) {
        return this.getFilter(appName).filterSpanEventAttributes(values2);
    }

    public Map<String, ?> filterTransactionSegmentAttributes(String appName, Map<String, Object> values2) {
        return this.getFilter(appName).filterTransactionSegmentAttributes(values2);
    }

    public boolean shouldIncludeSpanAttribute(String appName, String attributeName) {
        return this.getFilter(appName).shouldIncludeSpanAttribute(attributeName);
    }

    public boolean shouldIncludeErrorAttribute(String appName, String attributeName) {
        return this.getFilter(appName).shouldIncludeErrorAttribute(attributeName);
    }

    private AttributesFilter getFilter(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultFilter;
        }
        AttributesFilter filter = this.appNamesToFilters.get(appName);
        return filter == null ? this.defaultFilter : filter;
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        if (appName != null) {
            if (appName.equals(this.defaultAppName)) {
                this.defaultFilter = new AttributesFilter(agentConfig);
            } else {
                this.appNamesToFilters.put(appName, new AttributesFilter(agentConfig));
            }
        }
    }

    public String filterRequestUri(String appName, String destination, String uri) {
        Map<String, ?> filteredUriMap = this.getFilter(appName).filterAttributesForDestination(this.requestUriDummyMap, destination);
        return filteredUriMap.containsKey("request.uri") ? uri : null;
    }
}

