/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;

public class PointCutConfiguration {
    private final String name;
    private final String groupName;
    private final Config pointCutConfig;
    private final Config pointCutGroupConfig;
    private final boolean enabledByDefault;

    public PointCutConfiguration(Class<? extends PointCut> pc) {
        this(pc.getName(), null, true);
    }

    public PointCutConfiguration(String configurationName) {
        this(configurationName, null, true);
    }

    public PointCutConfiguration(String configurationName, boolean enabledByDefault) {
        this(configurationName, null, enabledByDefault);
    }

    public PointCutConfiguration(String configurationName, String configurationGroupName, boolean enabledByDefault) {
        this(configurationName, configurationGroupName, enabledByDefault, ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig());
    }

    public PointCutConfiguration(String configurationName, String configurationGroupName, boolean enabledByDefault, ClassTransformerConfig config) {
        this.name = configurationName;
        this.groupName = configurationGroupName;
        this.enabledByDefault = enabledByDefault;
        this.pointCutConfig = this.initConfig(configurationName, config);
        this.pointCutGroupConfig = this.initConfig(configurationGroupName, config);
    }

    public final String getName() {
        return this.name;
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public Config getConfiguration() {
        return this.pointCutConfig;
    }

    private Config initConfig(String name, ClassTransformerConfig classTransformerConfig) {
        Object pointCutConfig;
        Map config = Collections.emptyMap();
        if (name != null && (pointCutConfig = classTransformerConfig.getProperty(name)) instanceof Map) {
            config = (Map)pointCutConfig;
        }
        return new BaseConfig(config);
    }

    public boolean isEnabled() {
        boolean instrumentationDefaultDisabled;
        boolean classExplicitlyDisabled;
        boolean groupExplicitlyEnabled = this.pointCutGroupConfig.getProperty("enabled", false);
        boolean classExplicitlyEnabled = this.pointCutConfig.getProperty("enabled", false);
        if (groupExplicitlyEnabled || classExplicitlyEnabled) {
            Agent.LOG.info(MessageFormat.format("Enabled point cut \"{1}\" (\"{2}\")", this.getName(), this.getGroupName()));
            return true;
        }
        boolean groupExplicitlyDisabled = this.pointCutGroupConfig.getProperty("enabled", true) == false;
        boolean bl = classExplicitlyDisabled = this.pointCutConfig.getProperty("enabled", true) == false;
        if (groupExplicitlyDisabled || classExplicitlyDisabled) {
            Agent.LOG.info(MessageFormat.format("Disabled point cut \"{1}\" (\"{2}\")", this.getName(), this.getGroupName()));
            return false;
        }
        ClassTransformerConfig classTransformerConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig();
        boolean bl2 = instrumentationDefaultDisabled = !classTransformerConfig.isDefaultInstrumentationEnabled();
        if (instrumentationDefaultDisabled) {
            String msg = MessageFormat.format("Instrumentation is disabled by default. Disabled point cut \"{0}\" (\"{1}\")", this.getName(), this.getGroupName());
            Agent.LOG.info(msg);
            return false;
        }
        return this.enabledByDefault;
    }

    protected boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }
}

