/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.values;

import com.newrelic.agent.jmx.create.JmxMetricModifier;
import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.jmx.metrics.KafkaMetricGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KafkaConsumerJmxValues
extends JmxFrameworkValues {
    public static final String PREFIX = "kafka.consumer";
    protected static final Pattern BYTES_RECEIVED = Pattern.compile("^JMX/\"(.+)-(.+?)-BytesPerSec\"/");
    protected static final Pattern MESSAGES_RECEIVED = Pattern.compile("^JMX/\"(.+)-(.+?)-MessagesPerSec\"/");
    private static final JmxMetricModifier TOPIC_MODIFIER = new JmxMetricModifier(){

        @Override
        public String getMetricName(String fullMetricName) {
            Matcher m4 = BYTES_RECEIVED.matcher(fullMetricName);
            if (m4.matches() && m4.groupCount() == 2) {
                return "MessageBroker/Kafka/Topic/Consume/Named/" + m4.group(2) + "/Received/Bytes";
            }
            m4 = MESSAGES_RECEIVED.matcher(fullMetricName);
            if (m4.matches() && m4.groupCount() == 2) {
                return "MessageBroker/Kafka/Topic/Consume/Named/" + m4.group(2) + "/Received/Messages";
            }
            return "";
        }
    };
    private static final JmxMetric COUNT = KafkaMetricGenerator.COUNT_MONOTONIC.createMetric("Count");
    private static List<BaseJmxValue> METRICS = new ArrayList<BaseJmxValue>(1);

    @Override
    public List<BaseJmxValue> getFrameworkMetrics() {
        return METRICS;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    static {
        METRICS.add(new BaseJmxValue("\"kafka.consumer\":type=\"ConsumerTopicMetrics\",name=*", "JMX/{name}/", TOPIC_MODIFIER, new JmxMetric[]{COUNT}));
    }
}

