/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.InstrumentationWrapper;
import com.newrelic.agent.util.asm.Utils;
import com.newrelic.weave.utils.BootstrapLoader;
import com.newrelic.weave.utils.Streams;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.URL;
import java.util.ArrayList;

public class InstrumentationProxy
extends InstrumentationWrapper {
    private final boolean bootstrapClassIntrumentationEnabled;

    protected InstrumentationProxy(Instrumentation instrumentation, boolean enableBootstrapClassInstrumentationDefault) {
        super(instrumentation);
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.bootstrapClassIntrumentationEnabled = config.getProperty("enable_bootstrap_class_instrumentation", enableBootstrapClassInstrumentationDefault);
    }

    public static InstrumentationProxy getInstrumentationProxy(Instrumentation inst) {
        if (inst == null) {
            return null;
        }
        return new InstrumentationProxy(inst, true);
    }

    protected Instrumentation getInstrumentation() {
        return this.delegate;
    }

    @Override
    public void redefineClasses(ClassDefinition ... definitions) throws ClassNotFoundException, UnmodifiableClassException {
        if (this.isRedefineClassesSupported()) {
            super.redefineClasses(definitions);
        }
    }

    public Class<?>[] retransformUninstrumentedClasses(String ... classNames) throws UnmodifiableClassException, ClassNotFoundException {
        if (!this.isRetransformClassesSupported()) {
            return new Class[0];
        }
        ArrayList classList = new ArrayList(classNames.length);
        for (String className : classNames) {
            Class<?> clazz = Class.forName(className);
            if (PointCutClassTransformer.isInstrumented(clazz)) continue;
            classList.add(clazz);
        }
        Class[] classArray = classList.toArray(new Class[0]);
        if (!classList.isEmpty()) {
            this.retransformClasses(classArray);
        }
        return classArray;
    }

    public int getClassReaderFlags() {
        return 8;
    }

    public final boolean isBootstrapClassInstrumentationEnabled() {
        return this.bootstrapClassIntrumentationEnabled;
    }

    public boolean isAppendToClassLoaderSearchSupported() {
        return true;
    }

    public static void forceRedefinition(Instrumentation instrumentation, Class<?> ... classes) throws ClassNotFoundException, UnmodifiableClassException {
        ArrayList<ClassDefinition> toRedefine = new ArrayList<ClassDefinition>();
        for (Class<?> clazz : classes) {
            String classResourceName = Utils.getClassResourceName(clazz);
            URL resource = clazz.getResource(classResourceName);
            if (resource == null) {
                resource = BootstrapLoader.get().findResource(classResourceName);
            }
            if (resource != null) {
                try {
                    byte[] classfileBuffer = Streams.read(resource.openStream(), true);
                    toRedefine.add(new ClassDefinition(clazz, classfileBuffer));
                }
                catch (Exception e) {
                    Agent.LOG.finer("Unable to redefine " + clazz.getName() + " - " + e.toString());
                }
                continue;
            }
            Agent.LOG.finer("Unable to find resource to redefine " + clazz.getName());
        }
        if (!toRedefine.isEmpty()) {
            instrumentation.redefineClasses(toRedefine.toArray(new ClassDefinition[0]));
        }
    }
}

