/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.interfaces.SamplingPriorityQueue;
import com.newrelic.agent.model.PriorityAware;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.agent.util.MinAwareQueue;
import com.newrelic.agent.util.NoOpQueue;
import com.newrelic.agent.util.SynchronizedMinAwareQueue;
import com.newrelic.api.agent.NewRelic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class DistributedSamplingPriorityQueue<E extends PriorityAware>
implements SamplingPriorityQueue<E> {
    private final String appName;
    private final String serviceName;
    private final MinAwareQueue<E> data;
    private final AtomicInteger numberOfTries = new AtomicInteger();
    private final AtomicInteger sampled;
    private final Comparator<E> comparator;
    private final int maximumSize;

    public DistributedSamplingPriorityQueue(int reservoirSize) {
        this("", "", reservoirSize, null);
    }

    public DistributedSamplingPriorityQueue(String appName, String serviceName, int reservoirSize) {
        this(appName, serviceName, reservoirSize, null);
    }

    public DistributedSamplingPriorityQueue(int reservoirSize, Comparator<E> comparator) {
        this("", "", reservoirSize, comparator);
    }

    public DistributedSamplingPriorityQueue(String appName, String serviceName, int reservoirSize, Comparator<E> comparator) {
        this.appName = appName;
        this.serviceName = serviceName;
        this.comparator = comparator == null ? (left, right) -> Float.compare(right.getPriority(), left.getPriority()) : comparator;
        this.data = this.createQueue(reservoirSize, this.comparator);
        this.sampled = new AtomicInteger(0);
        this.maximumSize = reservoirSize;
    }

    private MinAwareQueue<E> createQueue(int reservoirSize, Comparator<E> comparator) {
        if (reservoirSize <= 0) {
            return new NoOpQueue();
        }
        return new SynchronizedMinAwareQueue<E>(reservoirSize, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retryAll(DistributedSamplingPriorityQueue<E> source2) {
        MinAwareQueue<E> minAwareQueue = source2.data;
        synchronized (minAwareQueue) {
            for (PriorityAware element : source2.data) {
                this.add(element);
            }
        }
    }

    @Override
    public void retryAll(SamplingPriorityQueue<E> source2) {
        for (PriorityAware element : source2.asList()) {
            this.add(element);
        }
    }

    @Override
    public boolean isFull() {
        return this.data.size() == this.maximumSize;
    }

    @Override
    public float getMinPriority() {
        return this.data.isEmpty() ? 0.0f : this.data.peekLast().getPriority();
    }

    @Override
    public int getNumberOfTries() {
        return this.numberOfTries.get();
    }

    @Override
    public void incrementNumberOfTries() {
        this.numberOfTries.incrementAndGet();
    }

    @Override
    public boolean add(E element) {
        this.incrementNumberOfTries();
        boolean added = this.data.offer(element);
        if (added && DistributedTraceUtil.isSampledPriority(element.getPriority())) {
            this.sampled.incrementAndGet();
        }
        return added;
    }

    @Override
    public E peek() {
        return (E)((PriorityAware)this.data.peek());
    }

    @Override
    public E poll() {
        return (E)((PriorityAware)this.data.poll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> asList() {
        ArrayList<E> elements;
        MinAwareQueue<E> minAwareQueue = this.data;
        synchronized (minAwareQueue) {
            elements = new ArrayList<E>(this.data);
        }
        Collections.sort(elements, this.comparator);
        return elements;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public int getTotalSampledPriorityEvents() {
        return this.sampled.get();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void logReservoirStats() {
        NewRelic.getAgent().getLogger().log(Level.FINER, "Application {0} saw {1} events for {2}, added {3} of sampling priority.", (Object)this.appName, (Object)this.getNumberOfTries(), (Object)this.serviceName, (Object)this.getTotalSampledPriorityEvents());
    }
}

