/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing.samplers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.SamplerConfig;
import com.newrelic.agent.tracing.samplers.Sampler;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;

public class ProbabilityBasedSampler
implements Sampler {
    private final long rejectionThreshold;

    public ProbabilityBasedSampler(SamplerConfig samplerConfig) {
        float samplingProbability = samplerConfig.getSamplerRatio().floatValue();
        if (!Float.isNaN(samplingProbability)) {
            this.rejectionThreshold = (long)((double)(1.0f - samplingProbability) * Math.pow(2.0, 56.0));
            NewRelic.getAgent().getLogger().log(Level.INFO, "ProbabilityBasedSampler: rejection threshold {0}", (Object)this.rejectionThreshold);
        } else {
            this.rejectionThreshold = (long)Math.pow(2.0, 56.0);
            NewRelic.getAgent().getLogger().log(Level.WARNING, "ProbabilityBasedSampler: Invalid sampling probability supplied; setting rejection threshold to {0}", (Object)this.rejectionThreshold);
        }
    }

    @Override
    public float calculatePriority(Transaction tx) {
        String traceId = Sampler.traceIdFromTransaction(tx);
        if (traceId != null && traceId.length() == 32) {
            try {
                String last14Chars = traceId.substring(18);
                return Long.parseUnsignedLong(last14Chars, 16) >= this.rejectionThreshold ? 2.0f : 0.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    @Override
    public String getType() {
        return "probability";
    }

    public long getRejectionThreshold() {
        return this.rejectionThreshold;
    }
}

