/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.toevent;

import com.newrelic.jfr.MethodSupport;
import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.toevent.EventToEvent;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.events.Event;
import java.util.Collections;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedStackTrace;
import jdk.jfr.consumer.RecordedThread;

public class MethodSampleMapper
implements EventToEvent {
    public static final String SIMPLE_CLASS_NAME = MethodSampleMapper.class.getSimpleName();
    public static final String EVENT_NAME = "jdk.ExecutionSample";
    public static final String NATIVE_EVENT_NAME = "jdk.NativeMethodSample";
    public static final String THREAD_STATE = "thread.state";
    public static final String STATE = "state";
    public static final String THREAD_NAME = "thread.name";
    public static final String SAMPLED_THREAD = "sampledThread";
    public static final String STACK_TRACE = "stackTrace";
    public static final String JFR_METHOD_SAMPLE = "JfrMethodSample";
    private final String eventName;

    private MethodSampleMapper(String eventName) {
        this.eventName = eventName;
    }

    public static MethodSampleMapper forExecutionSample() {
        return new MethodSampleMapper(EVENT_NAME);
    }

    public static MethodSampleMapper forNativeMethodSample() {
        return new MethodSampleMapper(NATIVE_EVENT_NAME);
    }

    @Override
    public List<Event> apply(RecordedEvent ev) {
        RecordedStackTrace trace = ev.getStackTrace();
        if (trace == null) {
            return Collections.emptyList();
        }
        long timestamp = ev.getStartTime().toEpochMilli();
        Attributes attr = new Attributes();
        RecordedThread sampledThread = null;
        if (RecordedObjectValidators.hasField(ev, SAMPLED_THREAD, SIMPLE_CLASS_NAME)) {
            sampledThread = ev.getThread(SAMPLED_THREAD);
        }
        attr.put(THREAD_NAME, sampledThread == null ? null : sampledThread.getJavaName());
        if (RecordedObjectValidators.hasField(ev, STATE, SIMPLE_CLASS_NAME)) {
            attr.put(THREAD_STATE, ev.getString(STATE));
        }
        attr.put(STACK_TRACE, MethodSupport.serialize(ev.getStackTrace()));
        return Collections.singletonList(new Event(JFR_METHOD_SAMPLE, attr, timestamp));
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }
}

