/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class BaseDurationSummarizer {
    public static final Supplier<Long> DEFAULT_CLOCK = () -> Instant.now().toEpochMilli();
    private final Supplier<Long> clock;
    protected final Optional<String> durationName;
    private long startTimeMs;
    protected long endTimeMs;
    protected Duration duration = Duration.ofNanos(0L);
    protected Duration minDuration = Duration.ofNanos(Long.MAX_VALUE);
    protected Duration maxDuration = Duration.ofNanos(Long.MIN_VALUE);

    public BaseDurationSummarizer(long startTimeMs) {
        this(startTimeMs, DEFAULT_CLOCK);
    }

    public BaseDurationSummarizer(long startTimeMs, Supplier<Long> clock) {
        this(startTimeMs, clock, null);
    }

    public BaseDurationSummarizer(long startTimeMs, Supplier<Long> clock, String durationName) {
        this.endTimeMs = this.startTimeMs = startTimeMs;
        this.clock = clock;
        this.durationName = Optional.ofNullable(durationName);
    }

    public void reset() {
        this.startTimeMs = this.clock.get();
        this.endTimeMs = 0L;
        this.duration = Duration.ofNanos(0L);
        this.minDuration = Duration.ofNanos(Long.MAX_VALUE);
        this.maxDuration = Duration.ofNanos(Long.MIN_VALUE);
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getEndTimeMs() {
        return this.endTimeMs;
    }

    public double getDurationMillis() {
        return this.duration.toMillis();
    }

    public double getMinDurationMillis() {
        return this.minDuration.toMillis();
    }

    public double getMaxDurationMillis() {
        return this.maxDuration.toMillis();
    }
}

