/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.tosummary.BaseDurationSummarizer;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.SimpleDurationSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public final class BasicGarbageCollectionSummarizer
implements EventToSummary {
    public static final String SIMPLE_CLASS_NAME = BasicGarbageCollectionSummarizer.class.getSimpleName();
    public static final String EVENT_NAME = "jdk.GarbageCollection";
    public static final String NAME = "name";
    public static final String JFR_GARBAGE_COLLECTION_MINOR_DURATION = "jfr.GarbageCollection.minorDuration";
    public static final String JFR_GARBAGE_COLLECTION_MAJOR_DURATION = "jfr.GarbageCollection.majorDuration";
    public static final String DURATION = "duration";
    public static final String DEF_NEW = "DefNew";
    public static final String G1_NEW = "G1New";
    public static final String PARALLEL_SCAVENGE = "ParallelScavenge";
    public static final String PAR_NEW = "ParNew";
    public static final String PS_MARK_SWEEP = "PSMarkSweep";
    public static final String CONCURRENT_MARK_SWEEP = "ConcurrentMarkSweep";
    public static final String G1_FULL = "G1Full";
    public static final String G1_OLD = "G1Old";
    public static final String PARALLEL_OLD = "ParallelOld";
    public static final String SERIAL_OLD = "SerialOld";
    public static final String ZGC = "Z";
    public static final String ZGC_MAJOR = "ZGC Major";
    public static final String ZGC_MINOR = "ZGC Minor";
    public static final String SHENANDOAH = "Shenandoah";
    private static final Logger logger = LoggerFactory.getLogger(BasicGarbageCollectionSummarizer.class);
    private final SimpleDurationSummarizer minorGcDurationSummarizer;
    private final SimpleDurationSummarizer majorGcDurationSummarizer;
    private final AtomicInteger minorGcCount = new AtomicInteger(0);
    private final AtomicInteger majorGcCount = new AtomicInteger(0);
    private long startTimeMs;
    private long minorGcEndTimeMs = 0L;
    private long majorGcEndTimeMs = 0L;
    private static final Set<String> MINOR_GC_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(BasicGarbageCollectionSummarizer.DEF_NEW);
            this.add(BasicGarbageCollectionSummarizer.G1_NEW);
            this.add(BasicGarbageCollectionSummarizer.PARALLEL_SCAVENGE);
            this.add(BasicGarbageCollectionSummarizer.PAR_NEW);
            this.add(BasicGarbageCollectionSummarizer.PS_MARK_SWEEP);
            this.add(BasicGarbageCollectionSummarizer.ZGC);
            this.add(BasicGarbageCollectionSummarizer.ZGC_MAJOR);
            this.add(BasicGarbageCollectionSummarizer.SHENANDOAH);
        }
    });
    private static final Set<String> MAJOR_GC_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add(BasicGarbageCollectionSummarizer.CONCURRENT_MARK_SWEEP);
            this.add(BasicGarbageCollectionSummarizer.G1_FULL);
            this.add(BasicGarbageCollectionSummarizer.G1_OLD);
            this.add(BasicGarbageCollectionSummarizer.PARALLEL_OLD);
            this.add(BasicGarbageCollectionSummarizer.SERIAL_OLD);
            this.add(BasicGarbageCollectionSummarizer.ZGC_MINOR);
        }
    });

    public BasicGarbageCollectionSummarizer() {
        this(Instant.now().toEpochMilli());
    }

    public BasicGarbageCollectionSummarizer(long startTimeMs) {
        this(startTimeMs, new SimpleDurationSummarizer(startTimeMs, BaseDurationSummarizer.DEFAULT_CLOCK, DURATION), new SimpleDurationSummarizer(startTimeMs, BaseDurationSummarizer.DEFAULT_CLOCK, DURATION));
    }

    public BasicGarbageCollectionSummarizer(long startTimeMs, SimpleDurationSummarizer minorGcDurationSummarizer, SimpleDurationSummarizer majorGcDurationSummarizer) {
        this.startTimeMs = startTimeMs;
        this.minorGcDurationSummarizer = minorGcDurationSummarizer;
        this.majorGcDurationSummarizer = majorGcDurationSummarizer;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void accept(RecordedEvent ev) {
        String name = null;
        if (RecordedObjectValidators.hasField(ev, NAME, SIMPLE_CLASS_NAME)) {
            name = (String)ev.getValue(NAME);
        }
        if (name != null) {
            if (MINOR_GC_NAMES.contains(name)) {
                this.minorGcEndTimeMs = ev.getStartTime().toEpochMilli();
                this.minorGcDurationSummarizer.accept(ev);
                this.minorGcCount.incrementAndGet();
            } else if (MAJOR_GC_NAMES.contains(name)) {
                this.majorGcEndTimeMs = ev.getStartTime().toEpochMilli();
                this.majorGcDurationSummarizer.accept(ev);
                this.majorGcCount.incrementAndGet();
            } else {
                logger.warn("Ignoring unsupported jdk.GarbageCollection event: " + name);
            }
        }
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes();
        Summary minorGcDuration = new Summary(JFR_GARBAGE_COLLECTION_MINOR_DURATION, this.minorGcCount.get(), this.minorGcDurationSummarizer.getDurationMillis(), this.minorGcDurationSummarizer.getMinDurationMillis(), this.minorGcDurationSummarizer.getMaxDurationMillis(), this.startTimeMs, this.minorGcEndTimeMs, attr);
        Summary majorGcDuration = new Summary(JFR_GARBAGE_COLLECTION_MAJOR_DURATION, this.majorGcCount.get(), this.majorGcDurationSummarizer.getDurationMillis(), this.majorGcDurationSummarizer.getMinDurationMillis(), this.majorGcDurationSummarizer.getMaxDurationMillis(), this.startTimeMs, this.majorGcEndTimeMs, attr);
        return Stream.of(minorGcDuration, majorGcDuration);
    }

    @Override
    public void reset() {
        this.startTimeMs = Instant.now().toEpochMilli();
        this.minorGcEndTimeMs = 0L;
        this.majorGcEndTimeMs = 0L;
        this.minorGcCount.set(0);
        this.majorGcCount.set(0);
        this.minorGcDurationSummarizer.reset();
        this.majorGcDurationSummarizer.reset();
    }
}

