/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.HeadersUtil;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.api.agent.ExtendedInboundHeaders;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import java.util.ArrayList;
import java.util.List;

public class DeobfuscatedInboundHeaders
extends ExtendedInboundHeaders {
    private InboundHeaders delegate;
    private String encodingKey;

    public DeobfuscatedInboundHeaders(InboundHeaders headers, String encodingKey) {
        this.delegate = headers;
        this.encodingKey = encodingKey;
    }

    public HeaderType getHeaderType() {
        return this.delegate.getHeaderType();
    }

    public String getHeader(String name) {
        if (this.encodingKey == null && !this.isDistributedTraceHeader(name)) {
            return null;
        }
        if (HeadersUtil.NEWRELIC_HEADERS.contains(name)) {
            String obfuscatedValue = this.getObfuscatedValue(name);
            if (obfuscatedValue == null) {
                return null;
            }
            return Obfuscator.deobfuscateNameUsingKey(obfuscatedValue, this.encodingKey);
        }
        return this.getObfuscatedValue(name);
    }

    private String getObfuscatedValue(String name) {
        String obfuscatedValue = this.delegate.getHeader(name);
        if (obfuscatedValue == null) {
            obfuscatedValue = this.delegate.getHeader(name.toUpperCase());
        }
        if (obfuscatedValue == null) {
            obfuscatedValue = this.delegate.getHeader(name.toLowerCase());
        }
        return obfuscatedValue;
    }

    public List<String> getHeaders(String name) {
        if (!(this.delegate instanceof ExtendedInboundHeaders)) {
            return null;
        }
        ExtendedInboundHeaders extendedDelegate = (ExtendedInboundHeaders)this.delegate;
        if (this.encodingKey == null && !this.isDistributedTraceHeader(name)) {
            return null;
        }
        if (HeadersUtil.NEWRELIC_HEADERS.contains(name)) {
            List<String> values2 = this.getObfuscatedValues(name, extendedDelegate);
            if (values2 == null) {
                return null;
            }
            ArrayList<String> obfuscatedValues = new ArrayList<String>(values2.size());
            for (String value : values2) {
                obfuscatedValues.add(Obfuscator.deobfuscateNameUsingKey(value, this.encodingKey));
            }
            return obfuscatedValues;
        }
        return this.getObfuscatedValues(name, extendedDelegate);
    }

    private List<String> getObfuscatedValues(String name, ExtendedInboundHeaders extendedDelegate) {
        List values2 = extendedDelegate.getHeaders(name);
        if (values2 == null) {
            values2 = extendedDelegate.getHeaders(name.toUpperCase());
        }
        if (values2 == null) {
            values2 = extendedDelegate.getHeaders(name.toLowerCase());
        }
        return values2;
    }

    private boolean isDistributedTraceHeader(String name) {
        return name.equalsIgnoreCase("newrelic") || name.equalsIgnoreCase("newrelic") || name.equalsIgnoreCase("traceparent") || name.equalsIgnoreCase("tracestate");
    }
}

