/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.Transaction;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.util.AgentError;
import com.newrelic.agent.util.asm.VariableLoader;
import com.newrelic.agent.util.asm.Variables;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class BytecodeGenProxyBuilder<T> {
    private final Class<T> target;
    private final GeneratorAdapter methodAdapter;
    private final boolean loadArguments;
    private Map<Object, Runnable> arguments;
    private final Variables variables;
    private Map<Type, VariableLoader> loaders;

    private BytecodeGenProxyBuilder(Class<T> target, GeneratorAdapter methodAdapter, boolean loadArguments) {
        this.target = target;
        this.methodAdapter = methodAdapter;
        this.variables = new VariableLoaderImpl();
        this.loadArguments = loadArguments;
    }

    public static <T> BytecodeGenProxyBuilder<T> newBuilder(Class<T> target, GeneratorAdapter methodAdapter, boolean loadArguments) {
        return new BytecodeGenProxyBuilder<T>(target, methodAdapter, loadArguments);
    }

    public Variables getVariables() {
        return this.variables;
    }

    private BytecodeGenProxyBuilder<T> addArgument(Object instance, Runnable runnable) {
        if (this.arguments == null) {
            this.arguments = new HashMap<Object, Runnable>();
        }
        if (runnable == null) {
            throw new AgentError("Runnable was null");
        }
        this.arguments.put(instance, runnable);
        return this;
    }

    public BytecodeGenProxyBuilder<T> addLoader(Type t2, VariableLoader loader) {
        if (this.loaders == null) {
            this.loaders = new HashMap<Type, VariableLoader>();
        }
        this.loaders.put(t2, loader);
        return this;
    }

    private Map<Type, VariableLoader> getLoaders() {
        return this.loaders == null ? Collections.emptyMap() : this.loaders;
    }

    private Map<Object, Runnable> getArguments() {
        return this.arguments == null ? Collections.emptyMap() : this.arguments;
    }

    public T build() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, java.lang.reflect.Method method, Object[] args2) throws Throwable {
                Method m4 = Method.getMethod(method);
                if (BytecodeGenProxyBuilder.this.loadArguments) {
                    for (int i = 0; i < m4.getArgumentTypes().length; ++i) {
                        Object value = args2[i];
                        Type type = m4.getArgumentTypes()[i];
                        this.load(type, value);
                    }
                }
                try {
                    this.getMethodVisitor().visitMethodInsn(185, Type.getInternalName(BytecodeGenProxyBuilder.this.target), m4.getName(), m4.getDescriptor(), true);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Agent.LOG.log(Level.FINER, "Error invoking {0}.{1}", BytecodeGenProxyBuilder.this.target.getName(), m4);
                    throw e;
                }
                return this.dummyReturnValue(m4.getReturnType());
            }

            private Object dummyReturnValue(Type returnType) {
                switch (returnType.getSort()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return 0;
                    }
                    case 7: {
                        return 0L;
                    }
                    case 6: {
                        return Float.valueOf(0.0f);
                    }
                    case 8: {
                        return 0.0;
                    }
                    case 1: {
                        return false;
                    }
                }
                return null;
            }

            private MethodVisitor getMethodVisitor() {
                if (BytecodeGenProxyBuilder.this.methodAdapter instanceof AdviceAdapter) {
                    try {
                        Field field = AdviceAdapter.class.getDeclaredField("isConstructor");
                        field.setAccessible(true);
                        if (field.getBoolean(BytecodeGenProxyBuilder.this.methodAdapter)) {
                            field = MethodVisitor.class.getDeclaredField("mv");
                            field.setAccessible(true);
                            return (MethodVisitor)field.get(BytecodeGenProxyBuilder.this.methodAdapter);
                        }
                    }
                    catch (Exception e) {
                        Agent.LOG.log(Level.FINE, e, e.toString());
                    }
                }
                return BytecodeGenProxyBuilder.this.methodAdapter;
            }

            private void load(Type type, Object value) {
                if (value == null) {
                    BytecodeGenProxyBuilder.this.methodAdapter.visitInsn(1);
                    return;
                }
                VariableLoader loader = (VariableLoader)BytecodeGenProxyBuilder.this.getLoaders().get(type);
                Runnable handler = (Runnable)BytecodeGenProxyBuilder.this.getArguments().get(value);
                if (handler != null) {
                    handler.run();
                } else if (loader != null) {
                    loader.load(value, BytecodeGenProxyBuilder.this.methodAdapter);
                } else if (value instanceof LoaderMarker) {
                    ((LoaderMarker)value).run();
                } else {
                    switch (type.getSort()) {
                        case 10: {
                            if (value instanceof String) {
                                BytecodeGenProxyBuilder.this.methodAdapter.push((String)value);
                            } else if (value.getClass().isEnum()) {
                                Enum theEnum = (Enum)value;
                                BytecodeGenProxyBuilder.this.methodAdapter.getStatic(type, theEnum.name(), type);
                            } else if (value instanceof Runnable) {
                                ((Runnable)value).run();
                            } else {
                                throw new AgentError("Unsupported type " + type);
                            }
                            return;
                        }
                        case 1: {
                            BytecodeGenProxyBuilder.this.methodAdapter.push((Boolean)value);
                            return;
                        }
                        case 5: {
                            BytecodeGenProxyBuilder.this.methodAdapter.push(((Number)value).intValue());
                            return;
                        }
                        case 7: {
                            BytecodeGenProxyBuilder.this.methodAdapter.push(((Number)value).longValue());
                            return;
                        }
                        case 6: {
                            BytecodeGenProxyBuilder.this.methodAdapter.push(((Number)value).floatValue());
                            return;
                        }
                        case 8: {
                            BytecodeGenProxyBuilder.this.methodAdapter.push(((Number)value).doubleValue());
                            return;
                        }
                        case 3: {
                            BytecodeGenProxyBuilder.this.methodAdapter.push(((Number)value).intValue());
                            return;
                        }
                        case 9: {
                            int count = Array.getLength(value);
                            BytecodeGenProxyBuilder.this.methodAdapter.push(count);
                            BytecodeGenProxyBuilder.this.methodAdapter.newArray(type.getElementType());
                            for (int i = 0; i < count; ++i) {
                                BytecodeGenProxyBuilder.this.methodAdapter.dup();
                                BytecodeGenProxyBuilder.this.methodAdapter.push(i);
                                this.load(type.getElementType(), Array.get(value, i));
                                BytecodeGenProxyBuilder.this.methodAdapter.arrayStore(type.getElementType());
                            }
                            return;
                        }
                    }
                    throw new AgentError("Unsupported type " + type);
                }
            }
        };
        ClassLoader classLoader = BytecodeGenProxyBuilder.class.getClassLoader();
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{this.target}, handler);
    }

    public static interface LoaderMarker
    extends Runnable {
    }

    private static abstract class Handler
    implements InvocationHandler {
        private Handler() {
        }

        @Override
        public final Object invoke(Object proxy, java.lang.reflect.Method method, Object[] args2) throws Throwable {
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            return this.doInvoke(proxy, method, args2);
        }

        protected abstract Object doInvoke(Object var1, java.lang.reflect.Method var2, Object[] var3);
    }

    public final class VariableLoaderImpl
    implements Variables {
        private Runnable loadThis() {
            return new LoaderMarker(){

                @Override
                public void run() {
                    BytecodeGenProxyBuilder.this.methodAdapter.visitVarInsn(25, 0);
                }

                public String toString() {
                    return "this";
                }
            };
        }

        @Override
        public Object loadThis(int access) {
            boolean isStatic = (access & 8) == 8;
            return isStatic ? null : this.loadThis();
        }

        @Override
        public <N extends Number> N loadLocal(int local, Type type, N value) {
            Runnable r = () -> BytecodeGenProxyBuilder.this.methodAdapter.loadLocal(local, type);
            return this.load(value, r);
        }

        @Override
        public <N extends Number> N load(N value, Runnable runnable) {
            BytecodeGenProxyBuilder.this.addArgument(value, runnable);
            return value;
        }

        @Override
        public Transaction loadCurrentTransaction() {
            return this.load(Transaction.class, new Runnable(){

                @Override
                public void run() {
                    BridgeUtils.getCurrentTransaction(BytecodeGenProxyBuilder.this.methodAdapter);
                }

                public String toString() {
                    return Transaction.class.getName() + '.' + "CURRENT";
                }
            });
        }

        @Override
        public <O> O load(Class<O> clazz, final Runnable runnable) {
            if (clazz.isInterface()) {
                Handler handler = new Handler(){

                    @Override
                    public Object doInvoke(Object proxy, java.lang.reflect.Method method, Object[] args2) {
                        runnable.run();
                        return null;
                    }

                    public String toString() {
                        return runnable.toString();
                    }
                };
                return (O)Proxy.newProxyInstance(AgentBridge.getAgent().getClass().getClassLoader(), new Class[]{clazz, LoaderMarker.class}, (InvocationHandler)handler);
            }
            if (clazz.isArray()) {
                Object key = Array.newInstance(clazz.getComponentType(), 0);
                BytecodeGenProxyBuilder.this.addArgument(key, runnable);
                return (O)key;
            }
            if (String.class.equals(clazz)) {
                String key = Long.toString(System.identityHashCode(runnable));
                BytecodeGenProxyBuilder.this.addArgument(key, runnable);
                return (O)key;
            }
            throw new AgentError("Unsupported type " + clazz.getName());
        }

        @Override
        public <O> O loadLocal(int localId, Class<O> clazz) {
            return this.load(clazz, () -> BytecodeGenProxyBuilder.this.methodAdapter.loadLocal(localId, Type.getType(clazz)));
        }
    }
}

