/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.events;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.Telemetry;

public final class Event
implements Telemetry {
    private final String eventType;
    private final Attributes attributes;
    private final long timestamp;

    public Event(String eventType, Attributes attributes, long timestamp) {
        if (eventType == null || "".equals(eventType)) {
            throw new IllegalArgumentException("eventType must not be empty.");
        }
        this.eventType = eventType;
        this.attributes = attributes;
        this.timestamp = timestamp;
    }

    public Event(Event other) {
        this.eventType = other.eventType;
        this.attributes = new Attributes(other.attributes);
        this.timestamp = other.timestamp;
    }

    public Event(String eventType, Attributes attributes) {
        this(eventType, attributes, System.currentTimeMillis());
    }

    public String getEventType() {
        return this.eventType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Event{eventType='" + this.eventType + '\'' + ", attributes=" + this.attributes + ", timestamp=" + this.timestamp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.getTimestamp() != event.getTimestamp()) {
            return false;
        }
        if (this.getEventType() != null ? !this.getEventType().equals(event.getEventType()) : event.getEventType() != null) {
            return false;
        }
        return this.getAttributes() != null ? this.getAttributes().equals(event.getAttributes()) : event.getAttributes() == null;
    }

    public int hashCode() {
        int result = this.getEventType() != null ? this.getEventType().hashCode() : 0;
        result = 31 * result + (this.getAttributes() != null ? this.getAttributes().hashCode() : 0);
        result = 31 * result + (int)(this.getTimestamp() ^ this.getTimestamp() >>> 32);
        return result;
    }
}

